package com.testor.module.fives.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.common.constant.StatusEnum;
import com.testor.module.fives.model.domain.*;
import com.testor.module.fives.model.dto.*;
import com.testor.module.fives.model.vo.*;
import com.testor.module.fives.service.*;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.workflow.apis.definition.controller.ProcessDefinitionController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 5s工具运用Controller
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:55
 */
@RestController
@RequestMapping("/module/fives/tool/use")
@Api(value = "TFivesToolUse", tags = "5s工具运用")
@Slf4j
public class TFivesToolUseController extends SuperController {
    @Autowired
    private TFivesToolUseService tFivesToolUseService;

    @Autowired
    private TFivesToolOplService tFivesToolOplService;
    @Autowired
    private TFivesToolCaseService tFivesToolCaseService;
    @Autowired
    private TFivesToolFocusService tFivesToolFocusService;

    @Autowired
    private TFivesToolEvaluateService tFivesToolEvaluateService;

    @Autowired
    private ProcessDefinitionController processDefinitionController;

    @Autowired
    private SysOrgService sysOrgService;

    @ApiOperation(value = "5s亮点数据统计", notes = "")
    @GetMapping(value = "/getBrighSpot")
    public BaseResponse<List<Map<String, String>>> getBrighSpot(TFivesToolUseBaseDTO addRequest) {
        BaseResponse<List<Map<String, String>>> listBaseResponse = new BaseResponse<>();
        String useType = addRequest.getUseType();
        LambdaQueryWrapper<TFivesToolUse> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(TFivesToolUse::getHostPost, BizConstants.STATUS_DELETE)
                .ne(TFivesToolUse::getStatus,BizConstants.STATUS_DELETE);
        if (StringHelper.isNotEmpty(useType)) {
            queryWrapper.eq(TFivesToolUse::getUseType, useType);
        }
        if (StringHelper.isNotEmpty(addRequest.getStartTime()) && StringHelper.isNotEmpty(addRequest.getEndTime())) {
            queryWrapper.between(TFivesToolUse::getCreateDate, addRequest.getStartTime()+" 00:00:00", addRequest.getEndTime()+" 23:59:59");
        }
        // 获取全部中粮推荐的热点数据
        List<TFivesToolUse> hostData =  tFivesToolUseService.list(queryWrapper);
        String orgId = ContextUtils.getLoginUser().getOrgId();
        // 所有区域公司
        List<SysOrg> orgs = sysOrgService.list(new LambdaQueryWrapper<SysOrg>().eq(SysOrg::getParentId, orgId)
                .eq(SysOrg::getIsDept,"0")
                .ne(SysOrg::getStatus, BizConstants.STATUS_DELETE));
        SysOrg sysOrg = new SysOrg();
        sysOrg.setOrgName("全部");
        sysOrg.setOrgId("123");
        orgs.add(sysOrg);
        // 存储所有区域公司及中粮推荐的亮点数据
        List<Map<String, String>> maps = new ArrayList<>();
        orgs.stream().forEach(item->{
            Map map = new HashMap<String,String>();
            // 该区域公司下的粮库id
            List<String> list = new ArrayList<>();
            // 区域公司下的粮库
            List<SysOrg> orgList = sysOrgService.list(new LambdaQueryWrapper<SysOrg>().eq(SysOrg::getParentId, item.getOrgId()).eq(SysOrg::getIsDept,"0").ne(SysOrg::getStatus, BizConstants.STATUS_DELETE));
            orgList.stream().forEach(i->{
                list.add(i.getOrgId());
            });


            // 该区域公司下的中粮推荐的热点数据
            List<TFivesToolUse> uses = null;
            if (ObjectHelper.isNotEmpty(list)) {
                LambdaQueryWrapper<TFivesToolUse> wrapper = new LambdaQueryWrapper<>();
                wrapper.in(TFivesToolUse::getHostPost, list).ne(TFivesToolUse::getStatus, BizConstants.STATUS_DELETE);
                if (StringHelper.isNotEmpty(useType)) {
                    wrapper.eq(TFivesToolUse::getUseType, useType);
                }
                if (StringHelper.isNotEmpty(addRequest.getStartTime()) && StringHelper.isNotEmpty(addRequest.getEndTime())) {
                    wrapper.between(TFivesToolUse::getCreateDate, addRequest.getStartTime(), addRequest.getEndTime());
                }
                uses = tFivesToolUseService.list(wrapper);

            }
            int size = 0;
            if (ObjectHelper.isNotEmpty(uses) && ObjectHelper.isNotEmpty(hostData)) {
                // 改区域公司中粮推荐的所有热点数据
                size = uses.size();
                 // 所占百分比
                String percent = percentMethod(size,hostData.size());
                map.put("orgName", item.getOrgName());
                map.put("orgId", item.getOrgId());
                map.put("treeLevel", item.getTreeLevel());
                map.put("hostData","亮点数,"+size+","+percent);
                map.put("sort", Integer.toString(size));
            } else if ("123".equals(item.getOrgId())) {
                map.put("orgName", item.getOrgName());
                map.put("orgId", item.getOrgId());
                map.put("treeLevel", item.getTreeLevel());
                map.put("hostData", "亮点数,"+hostData.size());
                map.put("sort", Integer.toString(Integer.MAX_VALUE));
            } else {
                map.put("orgName", item.getOrgName());
                map.put("orgId", item.getOrgId());
                map.put("treeLevel", item.getTreeLevel());
                map.put("hostData", "亮点数,0,0.00%");
                map.put("sort", Integer.toString(size));
            }
            maps.add(map);
        });
        maps.sort(Comparator.comparing((Map<String, String> h) -> (h.get("sort"))).reversed());
        listBaseResponse.setData(maps);

        return listBaseResponse;
    }

    /**
     * 计算占比
     * @param number1 区域公司数量
     * @param number2 总数量
     * @return
     */
    private String percentMethod(int number1, int number2) {
        DecimalFormat df = new DecimalFormat("0.0");
        if (number2 != 0) {
            return df.format((float) (number1 / (double) number2) * 100) + "%";
        } else {
            return "0%";
        }
    }

    @ApiOperation(value = "取消推荐为中粮亮点数据", notes = "")
    @GetMapping(value = "/NoRecommendBright")
    public BaseResponse<TFivesToolUse> NoRecommendBright(String id) throws Exception{
        BaseResponse<TFivesToolUse> response = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            TFivesToolUse service = tFivesToolUseService.getById(id);
            if (ObjectHelper.isNotEmpty(service)) {
                String orgId = service.getHostPost();
                if ("1".equals(orgId)) {
                    throw new BusinessException("该数据已经为非亮点数据");
                }
                service.setOrgId(orgId);
                service.setHostPost("1");
                tFivesToolUseService.updateById(service);
                response.setData(service);
            }
        }
        return response;
    }

    @ApiOperation(value = "推荐为中粮亮点数据", notes = "")
    @GetMapping(value = "/recommendBright")
    public BaseResponse<TFivesToolUse> recommendBright(String id) throws Exception{
        BaseResponse<TFivesToolUse> response = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            TFivesToolUse service = tFivesToolUseService.getById(id);
            if (ObjectHelper.isNotEmpty(service)) {
                String orgId = service.getOrgId();
                if ("1".equals(orgId)) {
                    throw new BusinessException("该数据已经为亮点数据");
                }
                service.setOrgId("1");
                service.setHostPost(orgId);
                tFivesToolUseService.updateById(service);
                response.setData(service);
            }
        }
        return response;
    }

    @ApiOperation(value = "编号自动生成", notes = "")
    @GetMapping(value = "/getAutoNum")
    public BaseResponse<TFivesToolUse> getAutoNum(TFivesToolUseBaseDTO addRequest) {
        BaseResponse<TFivesToolUse> baseResponse = new BaseResponse<>();
        // 当前年
        String year = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy"));
        // 0-opl一点课 "OPL-"；1-改善案例 case "GSAL-GJGY"；2-焦点课题 focus  "JDKT-"
        String useType = addRequest.getUseType();
        TFivesToolUse toolUse = new TFivesToolUse();
        String BM = "";
        switch (useType) {
            case "0":
                BM = "OPL-";
                break;
            case "1":
//                BM = "GSAL-GJGY";
                BM = "GSAL-";
                break;
            case "2":
                BM = "JDKT-";
                break;
        }
        TFivesToolUse one = tFivesToolUseService.getOne(new QueryWrapper<TFivesToolUse>().like(TFivesToolUse.SERIAL_NUMBER,BM+year)
                .orderByDesc(TFivesToolUse.SERIAL_NUMBER).last("limit 1"));
        if (ObjectHelper.isEmpty(one)) {
            String num = BM+year+"-001";
            toolUse.setSerialNumber(num);
            baseResponse.setData(toolUse);
        }else {
            // 获取全局编号
            String num = one.getSerialNumber();
            // 返回编号
            String number = returnCoding(num,year,BM);
            toolUse.setSerialNumber(number);
            baseResponse.setData(toolUse);
        }
        return baseResponse;
    }

    /**
     * 返回自动生成的编号
     * @param num 已有编号
     * @param year 当年
     * @param bm 编码规则
     * @return
     */
    private String returnCoding(String num, String year, String bm) {
        if (!num.contains(year)) {
            String n = bm+year+"-001";
            return n;
        }else {
            int lastIndex = num.lastIndexOf("-");
            // 自动生成的编码
            String substring = num.substring(lastIndex + 1);
            int i = Integer.parseInt(substring);
            i++;
            if (i < 10) {
                substring = "00"+i;
            }else if (i<100){
                substring = "0"+i;
            }else{
                substring = i+"";
            }
            String n = num.substring(0,lastIndex)+"-"+substring;
            return n;
        }
    }

    /* Generated Method*/
    @Transactional(rollbackFor = Exception.class)
    @ApiOperation(value = "新增 5s工具运用", notes = "Add TFivesToolUse")
    @PostMapping(value = "/add")
    public BaseResponse<TFivesToolUse> addEntity(@RequestBody TFivesToolUseBaseDTO addRequest) {
        BaseResponse<TFivesToolUse> baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }

        // 工具类型（0-opl一点课；1-改善案例；2-焦点课题）
        String useType = addRequest.getUseType();
        String orgId = ContextUtils.getLoginUser().getOrgId();

        TFivesToolUse tFivesToolUse = new TFivesToolUse();
        tFivesToolUse.setOrgId(orgId);
        tFivesToolUse.setSerialNumber(addRequest.getSerialNumber());
        tFivesToolUse.setUseType(useType);

        // 主任务添加
        tFivesToolUse = tFivesToolUseService.addEntity(tFivesToolUse);
        if (ObjectHelper.isEmpty(tFivesToolUse)) {
            throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具运用添加失败"));
        }

        String fivesToolUseId = tFivesToolUse.getId();
        boolean childSave;
        switch (useType) {
            case "0":
                // opl一点课
                TFivesToolOplDTO tFivesToolOplDTO = addRequest.getTFivesToolOplDTO();
                TFivesToolOpl tFivesToolOpl = BeanHelper.beanToBean(tFivesToolOplDTO, TFivesToolOpl.class);
                tFivesToolOpl.setParentId(fivesToolUseId);
                tFivesToolOpl.setSerialNumber(addRequest.getSerialNumber());
                childSave = tFivesToolOplService.save(tFivesToolOpl);
                break;
            case "1":
                TFivesToolCaseDTO tFivesToolCaseDTO = addRequest.getTFivesToolCaseDTO();
                tFivesToolCaseDTO.setParentId(fivesToolUseId);
                // 改善案例
                TFivesToolCase tFivesToolCase = BeanHelper.beanToBean(tFivesToolCaseDTO, TFivesToolCase.class);
                tFivesToolCase.setSerialNumber(addRequest.getSerialNumber());
                childSave = tFivesToolCaseService.save(tFivesToolCase);
                break;
            case "2":
                TFivesToolFocusDTO tFivesToolFocusDTO = addRequest.getTFivesToolFocusDTO();
                tFivesToolFocusDTO.setParentId(fivesToolUseId);
                // 焦点课题
                TFivesToolFocus tFivesToolFocus = BeanHelper.beanToBean(tFivesToolFocusDTO, TFivesToolFocus.class);
                tFivesToolFocus.setSerialNumber(addRequest.getSerialNumber());
                childSave = tFivesToolFocusService.save(tFivesToolFocus);
                break;
            default:
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具类型传入异常"));
        }

        if (!childSave) {
            throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具运用添加失败"));
        }
        baseResponse.setData(tFivesToolUse);
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用 ", notes = "Get TFivesToolUse By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TFivesToolUseBaseVO> getById(String id, String useType) {
        BaseResponse<TFivesToolUseBaseVO> baseResponse = new BaseResponse<>();
        TFivesToolUseBaseVO tFivesToolUseBaseVO;
        switch (useType) {
            case "0":
                // opl一点课
                QueryWrapper<TFivesToolOpl> oplQueryWrapper = new QueryWrapper<>();
                oplQueryWrapper.eq("parent_id", id);
                oplQueryWrapper.eq("status", StatusEnum.USE.getCode());
                TFivesToolOpl oplServiceOne = tFivesToolOplService.getOne(oplQueryWrapper);
                tFivesToolUseBaseVO = BeanHelper.beanToBean(oplServiceOne, TFivesToolOplVO.class);
                TFivesToolUse service = tFivesToolUseService.getById(oplServiceOne.getParentId());
                tFivesToolUseBaseVO.setSerialNumber(service.getSerialNumber());
                tFivesToolUseBaseVO.setOrgId(service.getOrgId());
                if ("1".equals(service.getOrgId())) {
                    tFivesToolUseBaseVO.setOrgId(service.getHostPost());
                }

                break;
            case "1":
                QueryWrapper<TFivesToolCase> caseQueryWrapper = new QueryWrapper<>();
                caseQueryWrapper.eq("parent_id", id);
                caseQueryWrapper.eq("status", StatusEnum.USE.getCode());
                TFivesToolCase caseServiceOne = tFivesToolCaseService.getOne(caseQueryWrapper);
                tFivesToolUseBaseVO = BeanHelper.beanToBean(caseServiceOne, TFivesToolCaseVO.class);
                TFivesToolUse toolUse = tFivesToolUseService.getById(caseServiceOne.getParentId());
                tFivesToolUseBaseVO.setSerialNumber(toolUse.getSerialNumber());
                tFivesToolUseBaseVO.setOrgId(toolUse.getOrgId());
                if ("1".equals(toolUse.getOrgId())) {
                    tFivesToolUseBaseVO.setOrgId(toolUse.getHostPost());
                }
                break;
            case "2":
                // 焦点课题
                QueryWrapper<TFivesToolFocus> focusQueryWrapper = new QueryWrapper<>();
                focusQueryWrapper.eq("parent_id", id);
                focusQueryWrapper.eq("status", StatusEnum.USE.getCode());
                TFivesToolFocus focusServiceOne = tFivesToolFocusService.getOne(focusQueryWrapper);
                tFivesToolUseBaseVO = BeanHelper.beanToBean(focusServiceOne, TFivesToolFocusVO.class);
                TFivesToolUse fivesToolUse = tFivesToolUseService.getById(focusServiceOne.getParentId());
                tFivesToolUseBaseVO.setSerialNumber(fivesToolUse.getSerialNumber());
                tFivesToolUseBaseVO.setOrgId(fivesToolUse.getOrgId());
                if ("1".equals(fivesToolUse.getOrgId())) {
                    tFivesToolUseBaseVO.setOrgId(fivesToolUse.getHostPost());
                }
                break;
            default:
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具类型传入异常"));
        }
        // 获取工具运用的所有评价
        List<TFivesToolEvaluate> list = tFivesToolEvaluateService.list(new QueryWrapper<TFivesToolEvaluate>().eq(TFivesToolEvaluate.TOOL_USE_ID, id)
                .ne(TFivesToolEvaluate.STATUS, BizConstants.STATUS_DELETE)
        );
        // 按照 级别区分
        Map<String, List<TFivesToolEvaluate>> levelToItemsMap = list.stream().collect(Collectors.groupingBy(item -> item.getTreeLevel().toString()));

        tFivesToolUseBaseVO.setMap(levelToItemsMap);
        baseResponse.setData(tFivesToolUseBaseVO);
        return baseResponse;
    }

    @ApiOperation(value = "修改 5s工具运用 ", notes = "Update TFivesToolUse By Id")
    @PutMapping(value = "/update")
    public BaseResponse<String> updateEntity(@RequestBody TFivesToolUseBaseDTO updateRequest) {
        BaseResponse<String> baseResponse = new BaseResponse<>();

        String id = updateRequest.getId();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(id)) {

            TFivesToolUse fivesToolUse = tFivesToolUseService.getById(id);
            if (ObjectHelper.isEmpty(fivesToolUse)) {
                baseResponse.setMsg("查无此值");
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                return baseResponse;
            }
            String useType = updateRequest.getUseType();
            boolean childUpdate = false;
            switch (useType) {
                case "0":
                    // opl一点课
                    TFivesToolOplDTO tFivesToolOplDTO = updateRequest.getTFivesToolOplDTO();
                    TFivesToolOpl tFivesToolOpl = BeanHelper.beanToBean(tFivesToolOplDTO, TFivesToolOpl.class);
                    tFivesToolOpl.setParentId(id);
                    TFivesToolOpl toolOpl = tFivesToolOplService.getOne(new QueryWrapper<TFivesToolOpl>().eq(TFivesToolOpl.PARENT_ID, id).ne(TFivesToolOpl.STATUS, BizConstants.STATUS_DELETE));
                    tFivesToolOpl.setId(toolOpl.getId());
                    childUpdate = tFivesToolOplService.saveOrUpdate(tFivesToolOpl);
                    break;
                case "1":
                    TFivesToolCaseDTO tFivesToolCaseDTO = updateRequest.getTFivesToolCaseDTO();
                    tFivesToolCaseDTO.setParentId(id);
                    TFivesToolCase toolCase = tFivesToolCaseService.getOne(new QueryWrapper<TFivesToolCase>().eq(TFivesToolCase.PARENT_ID, id).ne(TFivesToolCase.STATUS, BizConstants.STATUS_DELETE));
                    // 改善案例
                    TFivesToolCase tFivesToolCase = BeanHelper.beanToBean(tFivesToolCaseDTO, TFivesToolCase.class);
                    tFivesToolCase.setId(toolCase.getId());
                    childUpdate = tFivesToolCaseService.saveOrUpdate(tFivesToolCase);
                    break;
                case "2":
                    TFivesToolFocusDTO tFivesToolFocusDTO = updateRequest.getTFivesToolFocusDTO();
                    tFivesToolFocusDTO.setParentId(id);
                    TFivesToolFocus one = tFivesToolFocusService.getOne(new QueryWrapper<TFivesToolFocus>().eq(TFivesToolFocus.PARENT_ID, id).ne(TFivesToolFocus.STATUS, BizConstants.STATUS_DELETE));
                    // 焦点课题
                    TFivesToolFocus tFivesToolFocus = BeanHelper.beanToBean(tFivesToolFocusDTO, TFivesToolFocus.class);
                    tFivesToolFocus.setId(one.getId());
                    childUpdate = tFivesToolFocusService.saveOrUpdate(tFivesToolFocus);
                    break;
                default:
                    throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具类型传入异常"));
            }

            if (!childUpdate) {
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具运用修改失败"));
            }
        }
        return baseResponse;
    }


    @ApiOperation(value = "修改流程状态 5s工具运用 ", notes = "Update TFivesToolUse By Id")
    @PutMapping(value = "/updateProcessStatus")
    public BaseResponse<String> updateProcessStatus(@RequestBody TFivesToolUseBaseDTO updateRequest) {
        BaseResponse<String> baseResponse = new BaseResponse<>();

        String id = updateRequest.getId();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(id)) {

            TFivesToolUse fivesToolUse = tFivesToolUseService.getById(id);
            if (ObjectHelper.isEmpty(fivesToolUse)) {
                baseResponse.setMsg("查无此值");
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                return baseResponse;
            }
            String useType = updateRequest.getUseType();
            boolean childUpdate = false;
            switch (useType) {
                case "0":
                    // opl一点课
                    TFivesToolOplDTO tFivesToolOplDTO = updateRequest.getTFivesToolOplDTO();
                    TFivesToolOpl tFivesToolOpl = BeanHelper.beanToBean(tFivesToolOplDTO, TFivesToolOpl.class);
                    TFivesToolOpl toolOpl = tFivesToolOplService.getOne(new QueryWrapper<TFivesToolOpl>().eq(TFivesToolOpl.PARENT_ID, id).ne(TFivesToolOpl.STATUS, BizConstants.STATUS_DELETE));
                    childUpdate = tFivesToolOplService.update(new UpdateWrapper<TFivesToolOpl>().eq(TFivesToolOpl.ID,toolOpl.getId())
                        .set(TFivesToolOpl.PROCESS_ID,tFivesToolOpl.getProcessId())
                    );
                    break;
                case "1":
                    TFivesToolCaseDTO tFivesToolCaseDTO = updateRequest.getTFivesToolCaseDTO();
                    TFivesToolCase toolCase = tFivesToolCaseService.getOne(new QueryWrapper<TFivesToolCase>().eq(TFivesToolCase.PARENT_ID, id).ne(TFivesToolCase.STATUS, BizConstants.STATUS_DELETE));
                    // 改善案例
                    TFivesToolCase tFivesToolCase = BeanHelper.beanToBean(tFivesToolCaseDTO, TFivesToolCase.class);
                    childUpdate = tFivesToolCaseService.update(new UpdateWrapper<TFivesToolCase>().eq(TFivesToolCase.ID,toolCase.getId())
                        .set(TFivesToolCase.PROCESS_ID,tFivesToolCase.getProcessId())
                    );
                    break;
                case "2":
                    TFivesToolFocusDTO tFivesToolFocusDTO = updateRequest.getTFivesToolFocusDTO();
                    TFivesToolFocus one = tFivesToolFocusService.getOne(new QueryWrapper<TFivesToolFocus>().eq(TFivesToolFocus.PARENT_ID, id).ne(TFivesToolFocus.STATUS, BizConstants.STATUS_DELETE));
                    // 焦点课题
                    TFivesToolFocus tFivesToolFocus = BeanHelper.beanToBean(tFivesToolFocusDTO, TFivesToolFocus.class);
                    childUpdate = tFivesToolFocusService.update(new UpdateWrapper<TFivesToolFocus>().eq(TFivesToolFocus.ID,one.getId())
                        .set(TFivesToolFocus.PROCESS_ID,tFivesToolFocus.getProcessId())
                    );
                    break;
                default:
                    throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具类型传入异常"));
            }

            if (!childUpdate) {
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具运用修改失败"));
            }
        }
        return baseResponse;
    }

    @Transactional(rollbackFor = Exception.class)
    @ApiOperation(value = "删除 5s工具运用 ", notes = "delete TFivesToolUse By Id")
    @GetMapping(value = "/delete")
    public BaseResponse<String> deleteEntity(String id, String useType) {
        BaseResponse<String> baseResponse = new BaseResponse<>();
        TFivesToolUse data = new TFivesToolUse();
        data.setId(id);
        data.setStatus(BizConstants.STATUS_DELETE);
        boolean baseResult = tFivesToolUseService.updateById(data);
        boolean childResult = false;
        if (baseResult) {
            String processId = "";
            switch (useType) {
                case "0":
                    // opl一点课
                    QueryWrapper<TFivesToolOpl> oplQueryWrapper = new QueryWrapper<>();
                    oplQueryWrapper.eq("parent_id", id);
                    TFivesToolOpl oplServiceOne = new TFivesToolOpl();
                    oplServiceOne.setStatus(StatusEnum.DELETE.getCode());
                    childResult = tFivesToolOplService.update(oplServiceOne, oplQueryWrapper);
                    // 挂起流程
                    TFivesToolOpl one = tFivesToolOplService.getOne(new QueryWrapper<TFivesToolOpl>().eq(TFivesToolOpl.PARENT_ID, id));
                    processId = one.getProcessId();
//                    ProcessDefOpRequest processDefOpRequest = new ProcessDefOpRequest();
//                    processDefOpRequest.setProcessDefinitionId(one.getProcessId());
//                    processDefinitionController.suspendProcDef(processDefOpRequest);
                    break;
                case "1":
                    QueryWrapper<TFivesToolCase> caseQueryWrapper = new QueryWrapper<>();
                    caseQueryWrapper.eq("parent_id", id);
                    TFivesToolCase caseServiceOne = new TFivesToolCase();
                    caseServiceOne.setStatus(StatusEnum.DELETE.getCode());
                    childResult = tFivesToolCaseService.update(caseServiceOne, caseQueryWrapper);
                    // 挂起流程
                    TFivesToolCase cse = tFivesToolCaseService.getOne(new QueryWrapper<TFivesToolCase>().eq(TFivesToolCase.PARENT_ID, id));
                    processId = cse.getProcessId();
//                    ProcessDefOpRequest processDefOpRequestCase = new ProcessDefOpRequest();
//                    processDefOpRequestCase.setProcessDefinitionId(cse.getProcessId());
//                    processDefinitionController.suspendProcDef(processDefOpRequestCase);
                    break;
                case "2":
                    // 焦点课题
                    QueryWrapper<TFivesToolFocus> focusQueryWrapper = new QueryWrapper<>();
                    focusQueryWrapper.eq("parent_id", id);
                    TFivesToolFocus focusServiceOne = new TFivesToolFocus();
                    focusServiceOne.setStatus(StatusEnum.USE.getCode());
                    childResult = tFivesToolFocusService.update(focusServiceOne, focusQueryWrapper);
                    // 挂起流程
                    TFivesToolFocus foc = tFivesToolFocusService.getOne(new QueryWrapper<TFivesToolFocus>().eq(TFivesToolFocus.PARENT_ID, id));
                    processId = foc.getProcessId();
//                    ProcessDefOpRequest processDefOpRequestFoc = new ProcessDefOpRequest();
//                    processDefOpRequestFoc.setProcessDefinitionId(foc.getProcessId());
//                    processDefinitionController.suspendProcDef(processDefOpRequestFoc);
                    break;
                default:
                    throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具类型传入异常"));
            }
            if (childResult) {
                baseResponse.setData(processId);
            } else {
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "5s工具删除失败"));
            }
        }
        return baseResponse;
    }


    @ApiOperation(value = "获取 5s工具运用 分页列表", notes = "List TFivesToolUse with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TFivesToolUseListVO>> listEntity(TFivesToolUseParam param) {
        BaseResponse<BaseResponseList<TFivesToolUseListVO>> baseResponse = new BaseResponse<>();
        IPage<TFivesToolUseListVO> tFivesToolUseListVOIPage = tFivesToolUseService.selectToolUserLists(param);
        BaseResponseList<TFivesToolUseListVO> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(tFivesToolUseListVOIPage.getRecords());
        baseResponseList.setTotal(tFivesToolUseListVOIPage.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }


}
