package com.testor.module.iam.dao;

import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.module.iam.model.domain.IamSysUser;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("SysUserDao")
public interface SysUserDao extends SuperDao<SysUser> {

    /**
     * 查询有权限审批当前组织数据的用户
     * 逻辑：用户所在组织能够看到当前组织的数据
     */
    List<SysUser> selectApprovalUsersByOrgId(@Param("orgId") String orgId);

    /**
     * 查询有权限审批特定承包商记录的用户
     */
    List<SysUser> selectApprovalUsersForContractor(@Param("contractorId") String contractorId, @Param("orgId") String orgId);

    /**
     * 检查用户是否有审批角色
     */
    boolean checkUserHasApprovalRole(@Param("userId") String userId);

    /**
     * 检查组织访问权限
     */
    boolean checkOrgAccess(@Param("sourceOrgId") String sourceOrgId, @Param("targetOrgId") String targetOrgId);

}
