package com.testor.module.partner.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 相关方组织机构 删除参数对象
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */

@Data
@ApiModel(value = "TPartnerOrg 列表查询参数对象")
public class TPartnerOrgParam implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "企业选择")
    private List<String> condOrgIdList;

    @ApiModelProperty(value = "相关方单位名称")
    private String name;

    @ApiModelProperty(value = "资质状态（0-异常，1-正常，全部则不传）")
    private Integer certificateStatus;

    @ApiModelProperty(value = "是否为黑名单（0-否，1-是）")
    private Integer isBlacklist;

    private String orgId;

}
