/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongweb.container.Container;
import com.tongweb.container.Service;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.core.StandardWrapper;
import com.tongweb.container.startup.ServletContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;

public class GracefulShutdown {
    private static final Log logger = LogFactory.getLog(GracefulShutdown.class);
    private ServletContainer tongweb;
    private volatile boolean aborted = false;

    GracefulShutdown(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }

    void shutDownGracefully(GracefulShutdownCallback callback) {
        logger.info((Object)"Commencing graceful shutdown. Waiting for active requests to complete");
        new Thread(() -> this.doShutdown(callback), "tongweb-shutdown").start();
    }

    private void doShutdown(GracefulShutdownCallback callback) {
        List<Connector> connectors = this.getConnectors();
        connectors.forEach(this::close);
        try {
            for (Container host : this.tongweb.getEngine().findChildren()) {
                for (Container context : host.findChildren()) {
                    while (this.isActive(context)) {
                        if (this.aborted) {
                            logger.info((Object)"Graceful shutdown aborted with one or more requests still active");
                            callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
                            return;
                        }
                        Thread.sleep(50L);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        logger.info((Object)"Graceful shutdown complete");
        callback.shutdownComplete(GracefulShutdownResult.IDLE);
    }

    private List<Connector> getConnectors() {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Service service : this.tongweb.getServer().findServices()) {
            Collections.addAll(connectors, service.findConnectors());
        }
        return connectors;
    }

    private void close(Connector connector) {
        connector.pause();
        connector.getProtocolHandler().closeServerSocketGraceful();
    }

    private boolean isActive(Container context) {
        try {
            if (((StandardContext)context).getInProgressAsyncCount() > 0L) {
                return true;
            }
            for (Container wrapper : context.findChildren()) {
                if (((StandardWrapper)wrapper).getCountAllocated() <= 0) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void abort() {
        this.aborted = true;
    }
}

