/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.webresources;

import com.tongweb.container.webresources.ClasspathURLStreamHandler;
import com.tongweb.container.webresources.war.Handler;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TongWebURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String WAR_PROTOCOL = "war";
    private static final String CLASSPATH_PROTOCOL = "classpath";
    private static volatile TongWebURLStreamHandlerFactory instance = null;
    private final boolean registered;
    private final List<URLStreamHandlerFactory> userFactories = new CopyOnWriteArrayList<URLStreamHandlerFactory>();

    public static TongWebURLStreamHandlerFactory getInstance() {
        TongWebURLStreamHandlerFactory.getInstanceInternal(true);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TongWebURLStreamHandlerFactory getInstanceInternal(boolean register) {
        if (instance != null) return instance;
        Class<TongWebURLStreamHandlerFactory> clazz = TongWebURLStreamHandlerFactory.class;
        synchronized (TongWebURLStreamHandlerFactory.class) {
            if (instance != null) return instance;
            instance = new TongWebURLStreamHandlerFactory(register);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean register() {
        return TongWebURLStreamHandlerFactory.getInstanceInternal(true).isRegistered();
    }

    public static boolean disable() {
        return !TongWebURLStreamHandlerFactory.getInstanceInternal(false).isRegistered();
    }

    public static void release(ClassLoader classLoader) {
        if (instance == null) {
            return;
        }
        List<URLStreamHandlerFactory> factories = TongWebURLStreamHandlerFactory.instance.userFactories;
        block0: for (URLStreamHandlerFactory factory : factories) {
            for (ClassLoader factoryLoader = factory.getClass().getClassLoader(); factoryLoader != null; factoryLoader = factoryLoader.getParent()) {
                if (!classLoader.equals(factoryLoader)) continue;
                factories.remove(factory);
                continue block0;
            }
        }
    }

    private TongWebURLStreamHandlerFactory(boolean register) {
        this.registered = register;
        if (register) {
            URL.setURLStreamHandlerFactory(this);
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void addUserFactory(URLStreamHandlerFactory factory) {
        this.userFactories.add(factory);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (WAR_PROTOCOL.equals(protocol)) {
            return new Handler();
        }
        if (CLASSPATH_PROTOCOL.equals(protocol)) {
            return new ClasspathURLStreamHandler();
        }
        for (URLStreamHandlerFactory factory : this.userFactories) {
            URLStreamHandler handler = factory.createURLStreamHandler(protocol);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

