/*
 * Decompiled with CFR 0.152.
 */
package com.testor.config.interceptor;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import com.testor.biz.sys.datascope.model.domain.SysDataScope;
import com.testor.biz.sys.datascope.service.SysDataScopeService;
import com.testor.biz.sys.resource.model.domain.SysResource;
import com.testor.biz.sys.resource.service.SysResourceService;
import com.testor.config.interceptor.sqlparser.DataScopeSqlParser;
import com.testor.config.interceptor.sqlparser.datascope.DataScopeFactory;
import com.tongtech.tfw.backend.common.context.ContextHelper;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import java.sql.Connection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataScopeInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (SqlCommandType.SELECT != mappedStatement.getSqlCommandType() || StatementType.CALLABLE == mappedStatement.getStatementType()) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        Object paramObj = boundSql.getParameterObject();
        String originalSql = boundSql.getSql();
        Connection connection = (Connection)invocation.getArgs()[0];
        if (!originalSql.contains("TONG-TECH-101010-DATA-FILTER")) {
            return invocation.proceed();
        }
        originalSql = originalSql.replace("TONG-TECH-101010-DATA-FILTER", "");
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String contentPath = request.getContextPath();
        String uri = StringHelper.removePrefix((CharSequence)((String)request.getAttribute("url")), (CharSequence)contentPath);
        SysDataScopeService sysDataScopeService = (SysDataScopeService)ContextHelper.getBeanByType(SysDataScopeService.class);
        SysResourceService sysResourceService = (SysResourceService)ContextHelper.getBeanByType(SysResourceService.class);
        SysResource sysResource = (SysResource)((Object)sysResourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{SysResource::getResourceId}).eq(SysResource::getResourceUrl, (Object)uri)).eq(SuperModel::getStatus, (Object)"0")).last("LIMIT 1")));
        if (null != sysResource) {
            String relatedId = sysResource.getResourceId();
            Optional<String> dataScopeId = Optional.ofNullable(sysDataScopeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{SysDataScope::getCtrlData}).eq(SysDataScope::getResourceId, (Object)relatedId)).eq(SuperModel::getStatus, (Object)"0")).last("LIMIT 1"))).map(SysDataScope::getCtrlData);
            if (dataScopeId.isPresent()) {
                String userId = ContextUtils.getLoginUser().getUserId();
                if (StringHelper.isEmpty((CharSequence)userId)) {
                    // empty if block
                }
                if (StringHelper.isNotEmpty((CharSequence)userId)) {
                    DataScopeSqlParser dataScopeSqlParser = new DataScopeFactory().getSqlParser(dataScopeId.get());
                    String newSql = dataScopeSqlParser.parseSql(originalSql, userId);
                    log.info(newSql);
                    metaObject.setValue("delegate.boundSql.sql", (Object)newSql);
                }
            }
        }
        return invocation.proceed();
    }
}

