package com.testor.common.constant;

import com.tongtech.tfw.backend.common.models.response.ResponseInfo;

/**
 * @ClassName: IamBindStatusEnum
 * @Description: Iam账户绑定状态
 * @Author: lm
 * @CreateTime: 2023/12/29 14:15
 * @Version: 1.0
 */
public enum IamBindStatusEnum {

    BOUND(1000, "账户已绑定，重新单点登录"),
    BIND_BY_OTHER_IAM_USER(1001, "此账户已被其它E+账号绑定，请联系管理员"),
    UNBOUND(1002,"账户未绑定，跳转至绑定页面"),
    BIND_BY_OTHER_USER(1003, "此E+账号已被其它账户绑定，请联系管理员"),
    DEACTIVATED(1004, "账号被停用"),
    GET_TOKEN(1005, "获取Token异常"),
    BIND_BY_IAM_USER(1001, "此账户已被当前E+账号绑定");

    private final int code;
    private final String msg;

    private IamBindStatusEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String msg() {
        return this.msg;
    }

    public ResponseInfo transform() {
        return ResponseInfo.builder().code(this.code()).msg(this.msg()).build();
    }

}
