package com.testor.ddd.safetyControl.application.service.riskStatistics;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskStatistics.RiskStatisticsDTO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskStatistics.RiskStatisticsNumVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

public interface RiskStatisticsManageService {

    /**
     * 危险源数据统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceNum(RiskStatisticsDTO param);

    /**
     * 危险源数据统计(根据车间场所类型分组)
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceNumBySpaceType(RiskStatisticsDTO param);

    /**
     * 危险源等级统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceLevel(@Param("query") RiskStatisticsDTO param);

    /**
     * 危险源类型统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceType(RiskStatisticsDTO param);

    /**
     * 风险点数据统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointNum(RiskStatisticsDTO param);

    /**
     * 风险点数据统计(根据车间场所类型分组)
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointNumBySpaceType(RiskStatisticsDTO param);

    /**
     * 风险点等级统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointLevel(@Param("query") RiskStatisticsDTO param);

    /**
     * 风险点类型统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointType(RiskStatisticsDTO param);

    /**
     * 导入危险源
     * @param file
     * @return
     * @throws IOException
     */
    BaseResponse<String> importRiskSource(MultipartFile file) throws IOException;

    /**
     * 导入风险点
     * @param file
     * @return
     * @throws IOException
     */
    BaseResponse<String> importRiskPoint(MultipartFile file) throws IOException;
}
