package com.testor.module.accident.model.resp;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 事故统计
 * @date 2022/5/12 15:12
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "事故统计响应数据")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AccidentStatisticsResp<T> {

    @ApiModelProperty(value = "是否有数据")
    private Boolean isSource;

    @ApiModelProperty(value = "响应对象")
    private T source;

    private Long count;

//    @ApiModelProperty(value = "饼图响应对象")
//    private List<T> sourceList;

    /**
     * @author zhangyangfan@testor.com.cn
     * @description: 柱状图结构
     * @date: 2022/5/12 15:26
     */
    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Category {

        private List<Map<String, String>> xAxisMap = new ArrayList<>();

        private List<String> xAxis = new ArrayList<>();

        private List<Integer> valueList = new ArrayList<>();
    }

    /**
     * @author zhangyangfan@testor.com.cn
     * @description: 饼图结构
     * @date: 2022/5/12 15:26
     */
    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Pie {
        private String name;

        private Integer value;

        private String dictValue;

        @ApiModelProperty("首页 - 未遂事故统计 - 百分比")
        private Double rate;
    }
}
