package com.testor.module.appUpdate.controller;

import com.testor.module.appUpdate.model.domain.TSysAppPackage;
import com.testor.module.appUpdate.service.TSysAppPackageService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Api(value = "TSysAppPackageController", tags = "APP更新接口")
@RestController
@RequestMapping("/app")
public class TSysAppPackageController {

    @Autowired
    private TSysAppPackageService tSysAppPackageService;


    @PostMapping("/uploadPackage")
    @ApiOperation(value = "上传apk包", notes = "上传apk包")
    @ApiImplicitParam(name = "file", value = "上传的文件", dataType = "_File", dataTypeClass = MultipartFile.class, required = true)
    public BaseResponse uploadPackage(@RequestPart("file") MultipartFile file, TSysAppPackage tSysAppPackage){
        BaseResponse baseResponse = tSysAppPackageService.uploadPackage(file,tSysAppPackage);
        return baseResponse;
    }

    @GetMapping("/getLatestVersion")
    @ApiOperation(value = "获取最高版本信息", notes = "获取最高版本信息")
    public BaseResponse<TSysAppPackage> getLatestVersion(){
        BaseResponse<TSysAppPackage> baseResponse = tSysAppPackageService.getLatestVersion();
        return baseResponse;
    }

}
