package com.testor.module.contractor.manage.model.domain;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 承包商考核评价指标明细对象 t_contractor_evaluate_detail
 *
 * @author testor-framework
 * @date 2024-11-30 15:42:34
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_evaluate_detail")
@ApiModel(value = "TContractorEvaluateDetail对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorEvaluateDetail extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")

    @TableId("id")
    private String id;
    /**
     * 考核评价id
     */
    @ApiModelProperty(value = "考核评价id")

    @TableField("evaluate_id")
    private String evaluateId;

    /**
     * 维度指标项编号
     */
    @ApiModelProperty(value = "维度指标项编号")
    @TableField("index_code")
    private String indexCode;
    /**
     * 维度
     */
    @ApiModelProperty(value = "维度")

    @TableField("dimension")
    private String dimension;
    /**
     * 一级指标
     */
    @ApiModelProperty(value = "一级指标")

    @TableField("first_level")
    private String firstLevel;
    /**
     * 二级指标
     */
    @ApiModelProperty(value = "二级指标")

    @TableField("second_level")
    private String secondLevel;
    /**
     * 评价条款
     */
    @ApiModelProperty(value = "评价条款")

    @TableField("evaluation_terms")
    private String evaluationTerms;
    /**
     * 基本分值
     */
    @ApiModelProperty(value = "基本分值", example = "0")

    @TableField("basic_score")
    private Double basicScore;
    /**
     * 计分标准
     */
    @ApiModelProperty(value = "计分标准")

    @TableField("score_standard")
    private String scoreStandard;
    /**
     * 单次扣分
     */
    @ApiModelProperty(value = "单次扣分", example = "0")

    @TableField("score_deduct")
    private Double scoreDeduct;
    /**
     * 适用性，0 否 1 是
     */
    @ApiModelProperty(value = "适用性，0 否 1 是")

    @TableField("is_use")
    private String isUse;
    /**
     * 扣分说明
     */
    @ApiModelProperty(value = "扣分说明")

    @TableField("deduct_desc")
    private String deductDesc;
    /**
     * 得分
     */
    @ApiModelProperty(value = "得分", example = "0")

    @TableField("score")
    private BigDecimal score;

    public static final String ID = "id";
    public static final String EVALUATE_ID = "evaluate_id";
    public static final String DIMENSION = "dimension";
    public static final String FIRST_LEVEL = "first_level";
    public static final String SECOND_LEVEL = "second_level";
    public static final String EVALUATION_TERMS = "evaluation_terms";
    public static final String BASIC_SCORE = "basic_score";
    public static final String SCORE_STANDARD = "score_standard";
    public static final String SCORE_DEDUCT = "score_deduct";
    public static final String IS_USE = "is_use";
    public static final String DEDUCT_DESC = "deduct_desc";
    public static final String SCORE = "score";
    public static final String INDEX_CODE = "index_code";


}
