package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorMaterial;
import com.testor.module.contractor.ledger.model.domain.TContractorProtectiveEquipment;
import com.testor.module.contractor.ledger.service.TContractorMaterialService;
import com.testor.module.contractor.manage.dao.TContractorAllowMaterialDao;
import com.testor.module.contractor.manage.model.domain.TContractorAllowMaterial;
import com.testor.module.contractor.manage.model.domain.TContractorAllowProtective;
import com.testor.module.contractor.manage.model.dto.TContractorAllowMaterialParam;
import com.testor.module.contractor.manage.model.vo.TContractorAllowMaterialVo;
import com.testor.module.contractor.manage.service.TContractorAllowMaterialService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 准入信息-物料台账关联Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-26 14:08:48
 */
@Service
public class TContractorAllowMaterialServiceImpl extends SuperServiceImpl<TContractorAllowMaterialDao, TContractorAllowMaterial> implements TContractorAllowMaterialService
{
    @Autowired(required = false)
    private TContractorAllowMaterialDao tContractorAllowMaterialDao;
    @Autowired
    private TContractorMaterialService tContractorMaterialService;

    @Override
    public List<String> getIdsByAllowId(String allowId) {
        List<TContractorAllowMaterial> list = this.list(new LambdaQueryWrapper<TContractorAllowMaterial>().eq(TContractorAllowMaterial::getAllowId, allowId));
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(TContractorAllowMaterial::getMaterialId).collect(Collectors.toList());
    }

    @Override
    public List<TContractorAllowMaterial> listAllEntity(TContractorAllowMaterialParam param) {
        QueryWrapper<TContractorAllowMaterial> queryWrapper = this.createQuery(param);
        List<TContractorAllowMaterial> records= this.list(queryWrapper);
        for (TContractorAllowMaterial record : records) {
            String id = record.getMaterialId();
            TContractorMaterial byId = tContractorMaterialService.getById(id);
            record.setTContractorMaterial(byId);
            record.setId(id);
        }
        return records;
    }

    @Override
    public Page<TContractorAllowMaterialVo> listEntity(TContractorAllowMaterialParam param) {
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());

        Page<TContractorAllowMaterial> resultPage = new Page<>(page, limit);
        QueryWrapper<TContractorAllowMaterial> queryWrapper = this.createQuery(param);
        Page<TContractorAllowMaterial> pageList = this.page(resultPage, queryWrapper);
        List<TContractorAllowMaterial> records = pageList.getRecords();


        List<TContractorAllowMaterialVo> voList = new ArrayList<>();
        for (TContractorAllowMaterial record : records) {
            String id = record.getMaterialId();
            record.setId(id);
            TContractorMaterial byId = tContractorMaterialService.getById(id);
            record.setTContractorMaterial(byId);
            TContractorAllowMaterialVo vo = new TContractorAllowMaterialVo();
            if (byId == null) {
                continue;
            }
            BeanUtils.copyProperties(byId, vo);
            BeanUtils.copyProperties(record, vo);
            voList.add(vo);
        }
        Page<TContractorAllowMaterialVo> voPage = new Page<>(pageList.getCurrent(), pageList.getSize());
        voPage.setRecords(voList);
        voPage.setTotal(pageList.getTotal());
        return voPage;
    }


    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorAllowMaterial> createQuery(TContractorAllowMaterialParam queryParam){
        QueryWrapper<TContractorAllowMaterial> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getAllowId())){
            queryWrapper.eq(TContractorAllowMaterial.ALLOW_ID,queryParam.getAllowId());
        }
        if(StringHelper.isNotEmpty(queryParam.getMaterialId())){
            queryWrapper.eq(TContractorAllowMaterial.MATERIAL_ID,queryParam.getMaterialId());
        }
        if(StringHelper.isNotEmpty(queryParam.getBizId())){
            queryWrapper.eq(TContractorAllowMaterial.BIZ_ID,queryParam.getBizId());
        }
        if(StringHelper.isNotEmpty(queryParam.getContractorId())){
            queryWrapper.eq(TContractorAllowMaterial.CONTRACTOR_ID,queryParam.getContractorId());
        }
        if(StringHelper.isNotEmpty(queryParam.getProjId())){
            queryWrapper.eq(TContractorAllowMaterial.PROJ_ID,queryParam.getProjId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorAllowMaterial.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorAllowMaterial.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TContractorAllowMaterial.UPDATE_DATE);
        }
        return queryWrapper;
    }


}
