package com.testor.module.globalAlarm.model.dto;

import com.testor.module.globalAlarm.model.domain.TGlobalAlarm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 全局报警 删除参数对象
 *
 * @author testor-framework
 * @date 2023-02-08 11:09:19
 */

@Data
@ApiModel(value = "TGlobalAlarm 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TGlobalAlarmParam<T> extends TGlobalAlarm {
	@ApiModelProperty(value = "响应对象")
	private T source;


	@Getter
	@Setter
	@NoArgsConstructor
	@AllArgsConstructor
	public static class Category {

		@ApiModelProperty("x 轴时段")
		private List<String> xAxis = new ArrayList<>();
		@ApiModelProperty("y 轴数据")
		private List<Integer> valueList = new ArrayList<>();
	}

	@ApiModelProperty(value = "报警类型统计")
	private List<TGlobalAlarmParam> globalAlarms;

	@ApiModelProperty(value = "多个企业")
	private List<String> orgIds ;
	@ApiModelProperty(value = "开始时间")
	private String startTime ;

	@ApiModelProperty(value = "结束时间")
	private String endTime ;

	@ApiModelProperty(value = "报警数量")
	private Long num;

	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
