package com.testor.module.safeCheck.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.safeCheck.model.domain.TSafeCheckPerson;
import com.testor.module.safeCheck.model.domain.TSafeCheckPlan;
import com.testor.module.safeCheck.model.domain.TSafeCheckTask;
import com.testor.module.safeCheck.model.domain.TSafeCheckTaskPostpone;
import com.testor.module.safeCheck.model.dto.TSafeCheckTaskParam;
import com.testor.module.safeCheck.model.vo.TSafeCheckTaskRecordVo;
import com.testor.module.safeCheck.model.vo.TSafeCheckTaskVo;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 安全检查计划任务Service接口
 * 
 * @author testor-framework
 * @date 2024-09-03 08:04:19
 */
public interface TSafeCheckTaskService extends SuperService<TSafeCheckTask> {

    public TSafeCheckTask generateTasks(TSafeCheckPerson tSafeCheckPerson, TSafeCheckPlan tSafeCheckPlan, LocalDateTime taskStartDate, LocalDateTime TaskEndDate);

    /**
     * 定时任务下发
     */
    void createCheckTaskExecutor();

    TSafeCheckPlan buildStartAndEndTime(TSafeCheckPerson tSafeCheckPerson,LocalDateTime nowTime);


    boolean postponed(TSafeCheckTaskPostpone addRequest);

    Page<TSafeCheckTask> pageList(TSafeCheckTaskParam param);

    List<TSafeCheckTask> listList(TSafeCheckTaskParam param);

    TSafeCheckTaskVo details(String id);

    boolean completeTask(TSafeCheckTaskRecordVo addRequest);
}
