package com.testor.module.train.project.controller;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.JSONObject;
import com.testor.biz.sys.dict.data.controller.SysDictDataController;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataResponse;
import com.testor.common.core.utils.StringUtils;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.testor.module.sys.service.NewSysOrgService;
import com.testor.module.train.project.model.stat.ProjectStatPara;
import com.testor.module.train.project.model.stat.ProjectStatTotalVo;
import com.testor.module.train.project.service.TrainProjectStatisticsAllService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author caq
 * @date 2024/9/5
 * @description 教育培训计划-总体看板
 */
@RestController
@RequestMapping("/projectStatisticsAll")
@Api(value = "TrainProjectStatisticsAllController", tags = "教育培训计划-总体看板")
@Slf4j
public class TrainProjectStatisticsAllController extends SuperController {

    @Autowired
    private TrainProjectStatisticsAllService tTrainEvaluateManageService;
    @Autowired
    private NewSysOrgService newSysOrgService;
    @Autowired
    private SysDictDataController sysDictDataController;


    @ApiOperation(value = "培训计划数统计 ", notes = "培训计划数-第一层")
    @GetMapping(value = "/findProjectNumTotal")
    public BaseResponse<ProjectStatTotalVo> findProjectNumTotal(ProjectStatPara para) {
        convertPara(para);
        ProjectStatTotalVo statTotalVo = tTrainEvaluateManageService.findProjectNumTotal(para.getOrgId(), para.getStartTime(), para.getEndTime(), null);
        BaseResponse<ProjectStatTotalVo> baseResponse = new BaseResponse<>();
        baseResponse.setData(statTotalVo);
        return baseResponse;
    }

    @ApiOperation(value = "培训计划数 ", notes = "培训计划数-扇形图")
    @GetMapping(value = "/findProjectNumByOrgOrVisitType")
    public BaseResponse<JSONObject> findProjectNumByOrgOrVisitType(ProjectStatPara para) {
        //convertPara(para);
        List<ProjectStatTotalVo> voList = tTrainEvaluateManageService.findProjectNumByOrgOrVisitType(para.getOrgId(),
                para.getStartTime(), para.getEndTime(), para.getType());

        SysDictDataResponse sysDictDataResponse = findFanChartTypeName(para);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", voList);
        jsonObject.put("sysDictDataResponse", sysDictDataResponse);
        BaseResponse<JSONObject> baseResponse = new BaseResponse<>();
        baseResponse.setData(jsonObject);
        return baseResponse;
    }

    @ApiOperation(value = "培训人数 ", notes = "培训人数-扇形图")
    @GetMapping(value = "/findPersonNumByOrgOrVisitType")
    public BaseResponse<JSONObject> findPersonNumByOrgOrVisitType(ProjectStatPara para) {
        //convertPara(para);
        List<ProjectStatTotalVo> voList = tTrainEvaluateManageService.findPersonNumByOrgOrVisitType(para.getOrgId(),
                para.getStartTime(), para.getEndTime(), para.getType());

        SysDictDataResponse sysDictDataResponse = findFanChartTypeName(para);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", voList);
        jsonObject.put("sysDictDataResponse", sysDictDataResponse);
        BaseResponse<JSONObject> baseResponse = new BaseResponse<>();
        baseResponse.setData(jsonObject);

        return baseResponse;
    }

    @ApiOperation(value = "培训学时 ", notes = "培训学时-列表")
    @GetMapping(value = "/findTrainTimeByOrgOrVisitType")
    public BaseResponse<JSONObject> findTrainTimeByOrgOrVisitType(ProjectStatPara para) {
        //convertPara(para);
        List<ProjectStatTotalVo> voList = tTrainEvaluateManageService.findTrainTimeByOrgOrVisitType(para.getOrgId(),
                para.getStartTime(), para.getEndTime(), para.getType());
        SysDictDataResponse sysDictDataResponse = findFanChartTypeName(para);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", voList);
        jsonObject.put("sysDictDataResponse", sysDictDataResponse);
        BaseResponse<JSONObject> baseResponse = new BaseResponse<>();
        baseResponse.setData(jsonObject);
        return baseResponse;
    }

    @ApiOperation(value = "培训评价 ", notes = "培训评价")
    @GetMapping(value = "/findTrainEvaluateStat")
    public BaseResponse<ProjectStatTotalVo> findTrainEvaluateStat(ProjectStatPara para) {
        convertPara(para);
        ProjectStatTotalVo trainEvaluateStat = tTrainEvaluateManageService.findTrainEvaluateStat(para.getOrgId(),
                para.getStartTime(), para.getEndTime(), null);
        BaseResponse<ProjectStatTotalVo> baseResponse = new BaseResponse<>();
        baseResponse.setData(trainEvaluateStat);
        return baseResponse;
    }

    @ApiOperation(value = "培训类型人数 ", notes = "培训类型人数")
    @GetMapping(value = "/findTrainTypeStat")
    public BaseResponse<List<ProjectStatTotalVo>> findTrainTypeStat(ProjectStatPara para) {
        convertPara(para);
        List<ProjectStatTotalVo> trainTypeStat = tTrainEvaluateManageService.findTrainTypeStat(para.getOrgId(),
                para.getStartTime(), para.getEndTime());
        BaseResponse<List<ProjectStatTotalVo>> baseResponse = new BaseResponse<>();
        baseResponse.setData(trainTypeStat);
        return baseResponse;
    }


    /**
     * 扇形图类型名称
     * @return
     */
    private SysDictDataResponse findFanChartTypeName(ProjectStatPara para) {
        convertPara(para);
        String nature = "";
        List<NewSysOrg> childrenById = newSysOrgService.getChildrenById(para.getOrgId());
        if (CollectionUtils.isNotEmpty(childrenById)) {
            nature = newSysOrgService.getOrgNatureById(childrenById.get(0).getOrgId());
        } else {
            nature = newSysOrgService.getOrgNatureById(para.getOrgId());
        }
        if (StringUtils.isBlank(nature)) {
            nature = "2";
        }
        BaseResponse<String> baseResponse = new BaseResponse<>();
        return sysDictDataController.getDictTypeDetail("", "NATURE", nature).getData();
    }


    private void convertPara(ProjectStatPara para) {
        String orgId = para.getOrgId();
        String startTime = para.getStartTime();
        String endTime = para.getEndTime();
        if (StringUtils.isAnyBlank(startTime, endTime)) {
            startTime = LocalDate.now().withDayOfMonth(1).atStartOfDay().format(DatePattern.NORM_DATETIME_FORMATTER);
            endTime = LocalDateTime.now().format(DatePattern.NORM_DATETIME_FORMATTER);
            para.setStartTime(startTime);
            para.setEndTime(endTime);
        }
        if (StringUtils.isBlank(orgId)) {
            orgId = ContextUtils.getLoginUser().getOrgId();
            para.setOrgId(orgId);
        }
        if (StringUtils.isBlank(para.getType())) {
            para.setType("1");
        }
    }


}
