/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.testor.workflow.form.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author sj form表单绑定到模型流程节点上
 */
@Data
public class ZModelFormDTO{

    @ApiModelProperty(required = true,value = "formId")
    private String id;
    @ApiModelProperty(required = true, value = "表单名称")
    private String name;
    @ApiModelProperty(required = true, value = "表单key,唯一值")
    private String key;
    @ApiModelProperty(required = true,value = "模型id")
    private String modelId;
    @ApiModelProperty(required = true,value = "模型节点id")
    private String elementNodeId;
}
