/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.io;

import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.util.Assert;

public class IoHelper {
    public static byte[] readBytes(InputStream in) throws FrameworkException {
        return IoHelper.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean closeFlag) throws FrameworkException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoHelper.copy(in, out);
        if (closeFlag) {
            IoHelper.close(in);
        }
        return out.toByteArray();
    }

    public static void write(OutputStream out, boolean closeFlag, byte[] data) throws FrameworkException {
        try {
            out.write(data);
        }
        catch (IOException e) {
            throw new FrameworkException(e);
        }
        finally {
            if (closeFlag) {
                IoHelper.close(out);
            }
        }
    }

    public static long copy(InputStream in, OutputStream out) throws FrameworkException {
        return IoHelper.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws FrameworkException {
        Assert.notNull((Object)in, (String)"InputStream is null !");
        Assert.notNull((Object)out, (String)"OutputStream is null !");
        if (bufferSize <= 0) {
            bufferSize = 8192;
        }
        byte[] buffer = new byte[bufferSize];
        long size = 0L;
        try {
            int i = in.read(buffer);
            while (i != -1) {
                out.write(buffer, 0, i);
                out.flush();
                size += (long)i;
                i = in.read(buffer);
            }
        }
        catch (IOException e) {
            throw new FrameworkException(e);
        }
        return size;
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

