/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongweb.container.Context;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TongWebErrorPage {
    private static final String ERROR_PAGE_CLASS = "com.tongweb.web.util.descriptor.web.ErrorPage";
    private final String location;
    private final String exceptionType;
    private final int errorCode;
    private final Object nativePage;

    TongWebErrorPage(ErrorPage errorPage) {
        this.location = errorPage.getPath();
        this.exceptionType = errorPage.getExceptionName();
        this.errorCode = errorPage.getStatusCode();
        this.nativePage = this.createNativePage();
    }

    private Object createNativePage() {
        try {
            if (ClassUtils.isPresent((String)ERROR_PAGE_CLASS, null)) {
                return BeanUtils.instantiateClass((Class)ClassUtils.forName((String)ERROR_PAGE_CLASS, null));
            }
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
        return null;
    }

    public void addToContext(Context context) {
        Assert.state((this.nativePage != null ? 1 : 0) != 0, (String)"No ServletContainer detected so no native error page exists");
        if (ClassUtils.isPresent((String)ERROR_PAGE_CLASS, null)) {
            com.tongweb.web.util.descriptor.web.ErrorPage errorPage = (com.tongweb.web.util.descriptor.web.ErrorPage)this.nativePage;
            errorPage.setLocation(this.location);
            errorPage.setErrorCode(this.errorCode);
            errorPage.setExceptionType(this.exceptionType);
            context.addErrorPage(errorPage);
        } else {
            this.callMethod(this.nativePage, "setLocation", this.location, String.class);
            this.callMethod(this.nativePage, "setErrorCode", this.errorCode, Integer.TYPE);
            this.callMethod(this.nativePage, "setExceptionType", this.exceptionType, String.class);
            this.callMethod(context, "addErrorPage", this.nativePage, this.nativePage.getClass());
        }
    }

    private void callMethod(Object target, String name, Object value, Class<?> type) {
        Method method = ReflectionUtils.findMethod(target.getClass(), (String)name, (Class[])new Class[]{type});
        ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{value});
    }
}

