/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class EnvUtils {
    public static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            byte[] mac = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || netInterface.isPointToPoint() || !netInterface.isUp() || (mac = netInterface.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < mac.length; ++i2) {
                    sb.append(String.format("%02X%s", mac[i2], i2 < mac.length - 1 ? "-" : ""));
                }
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static List<String> getMacAddressList() {
        ArrayList<String> results = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            byte[] mac = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || netInterface.isPointToPoint() || !netInterface.isUp() || (mac = netInterface.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < mac.length; ++i2) {
                    sb.append(String.format("%02X%s", mac[i2], i2 < mac.length - 1 ? "-" : ""));
                }
                if (sb.length() <= 0) continue;
                results.add(sb.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static int getCpu() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || netInterface.isPointToPoint() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static List<String> getIpAddressList() {
        ArrayList<String> results = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || netInterface.isPointToPoint() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    results.add(ip.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static String getMacAddressWithHighPriority() {
        try {
            String ipAddressWithHighPriority = EnvUtils.getIpAddressWithHighPriority();
            InetAddress localIp = InetAddress.getByName(ipAddressWithHighPriority);
            NetworkInterface byInetAddress = NetworkInterface.getByInetAddress(localIp);
            byte[] mac = byInetAddress.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < mac.length; ++i2) {
                sb.append(String.format("%02X%s", mac[i2], i2 < mac.length - 1 ? "-" : ""));
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getIpAddressWithHighPriority() {
        TreeSet<Map.Entry<String, Integer>> sortedIpMap = EnvUtils.entriesSortedByValuess(EnvUtils.getIpAddressWithPriority());
        return sortedIpMap.first().getKey();
    }

    public static Map<String, Integer> getIpAddressWithPriority() {
        List<String> ipAddressList = EnvUtils.getIpAddressList();
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        for (String tempIp : ipAddressList) {
            String firstIpPhase;
            Integer priorityNum = 0;
            switch (firstIpPhase = tempIp.substring(0, tempIp.indexOf("."))) {
                case "127": 
                case "255": {
                    priorityNum = Integer.MAX_VALUE;
                    break;
                }
                case "172": {
                    priorityNum = 101;
                    break;
                }
                case "192": {
                    priorityNum = 100;
                    break;
                }
                default: {
                    priorityNum = 0;
                }
            }
            resultMap.put(tempIp, priorityNum);
        }
        return resultMap;
    }

    public static <K, V extends Comparable<V>> TreeSet<Map.Entry<K, V>> entriesSortedByValuess(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }
}

