package com.testor.common.core.enums;

import com.testor.common.core.domain.ResponseInfo;

public enum BaseStatusEnum {
    SUCCESS(200, "请求成功"),
    UNKNOWN(996, "未知错误"),
    UNKNOWN_API_TYPE(501, "未知的接口类型"),
    UNAUTHORIZED(600, "无访问权限"),
    TOKEN_INVALID(601, "token过期，请重新登录"),
    UN_LOG(602, "未登录"),
    UN_TOKEN(603, "token未传递"),
    UN_SIGN(800, "sign签名未传递"),
    SIGN_ERROR(801, "sign签名不正确"),
    UN_TIMESTAMP(802, "timestamp时间戳未传递"),
    UN_VALID_TIMESTAMP(803, "timestamp失效"),
    UN_DATA(804, "data数据未传递"),
    RELATE_UPDATE_FAILED(805, "关联数据删除失败");

    private final int code;
    private final String msg;

    private BaseStatusEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String msg() {
        return this.msg;
    }

    public ResponseInfo transform() {
        return ResponseInfo.builder().code(this.code()).msg(this.msg()).build();
    }
}