package com.testor.ddd.safetyControl.domain.space.entity;

import com.testor.ddd.safetyControl.infrastructure.repository.space.entity.TSafeSpaceDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.space.TSafeSpaceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeSpaceRepo {

    /**
     * 检测 名称、编码 是否都唯一
     * @param id
     * @param bizId level = 1 时 此值为space_type_id；2 :space_id
     * @param level 等级 1-车间场所名称；2-作业区域
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeSpaceDTO> checkUniqueness(String id, String bizId, Integer level, String name, String code);

    int insert(TSafeSpaceDTO spaceDTO);

    int updateById(TSafeSpaceDTO spaceDTO);

    /**
     * 车间场所分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeSpaceVO> listPageByWorkshop(TSafeSpaceDTOParam param);

    /**
     * 作业区域分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeSpaceVO> listPageByWorkArea(TSafeSpaceDTOParam param);

    /**
     * 根据编码查询
     * @param spaceCode
     * @return
     */
    List<TSafeSpaceVO> listByCode(String spaceCode);


    TSafeSpaceDTO findById(String id);

    boolean deleteById(String id);

    List<TSafeSpaceDTO> listAllEntity(TSafeSpaceDTOParam param);

    /**
     * 通过 车间场所类型 删除
     * @param spaceTypeId
     * @return
     */
    boolean deleteBySpaceTypeId(String spaceTypeId);

    Integer replaceCode(String spaceTypeId, String oldCode, String newCode);

    boolean saveBatch(List<TSafeSpaceDTO> spaceDTOList);

    List<TSafeSpaceDTO> findBySpaceTypeId(String id);

    /**
     * 按照类型和机构ID查询空间场所
     * @param typeId
     * @param orgId
     * @return
     */
    List<TSafeSpaceDO> findSpaceListByTypeIdAndOrgId(String typeId,String orgId);


    List<String> getSpaceTypeIdsByOrgId(String orgId);

    /**
     * 按照空间场所和机构ID查询作业活动区域
     * @param spaceId
     * @param orgId
     * @return
     */
    List<TSafeSpaceDO> findRegionalListByTypeIdAndOrgId(String spaceId,String orgId);


    TSafeSpaceDTO findBySpaceName(String name,String orgId);

    List<TSafeSpaceDO> findAllSpacesByTypeIdsAndOrgId(List<String> spaceTypeIdsByOrgId, String orgId);

    List<TSafeSpaceVO> listSafeSpaceAll(TSafeSpaceDTOParam param);
}
