package com.testor.module.hazard.service.impl;

import com.testor.common.constant.RemindConstants;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.enums.WorkPlanStatusEnum;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.testor.module.hazard.service.TimeoutRemindStrategy;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.service.TMsgNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component(RemindConstants.REMIND_TYPE_PRE)
public class WillTimeoutStrategy extends BaseReminderStrategy implements TimeoutRemindStrategy {

    @Autowired
    private TMsgNoticeService tMsgNoticeService;
    @Autowired
    private THazardWorkPlanService tHazardWorkPlanService;


    @Override
    public void remind(String id) {
        THazardWorkPlan tHazardWorkPlan = tHazardWorkPlanService.getById(id);
        if (tHazardWorkPlan != null){
            String workStatus = tHazardWorkPlan.getWorkStatus();
            if (!workStatus.equals(WorkPlanStatusEnum.CLOSED.getValue()) || !workStatus.equals(WorkPlanStatusEnum.CANCELED.getValue())){
                List<TMsgNotice> sendNotice = sendNotice(tHazardWorkPlan, "作业即将超时",  tHazardWorkPlan.getEarlyReminderTime() + "分钟");
                tMsgNoticeService.saveBatch(sendNotice);
            }
        }
    }

}
