package com.testor.module.notice.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.testor.biz.sys.org.dao.SysOrgDao;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.module.notice.dao.TSysNoticeDao;
import com.testor.module.notice.dao.TSysNoticeTopDao;
import com.testor.module.notice.model.domain.TSysNotice;
import com.testor.module.notice.model.domain.TSysNoticeTop;
import com.testor.module.notice.service.TSysNoticeTopService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * noticeService业务层处理
 *
 * @author tong-framework
 * @date 2022-04-27 18:10:12
 */
@Service
public class TSysNoticeServiceTopImpl extends SuperServiceImpl<TSysNoticeTopDao, TSysNoticeTop> implements TSysNoticeTopService {
    @Autowired(required = false)
    private TSysNoticeDao tSysNoticeDao;

    @Autowired
    private TSysNoticeTopDao tSysNoticeTopDao;

    @Autowired
    private SysOrgDao sysOrgDao;

    @Override
    public BaseResponse<TSysNotice> top(TSysNotice addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        TSysNoticeTop tSysNoticeTop = new TSysNoticeTop();
        tSysNoticeTop.setNoticeId(addRequest.getId());
        tSysNoticeTop.setId(IdHelper.getId32bit());
        tSysNoticeTop.setStatus("0");
        //获取公司层级
        if (addRequest.getUserOrgId() != null) {
            SysOrg sysOrg = sysOrgDao.selectById(addRequest.getUserOrgId());
            tSysNoticeTop.setOrgId(sysOrg.getOrgId());
            tSysNoticeTop.setLevel(sysOrg.getTreeLevel());
        }
        Integer count = tSysNoticeTopDao.selectCount(new QueryWrapper<TSysNoticeTop>().eq("notice_id", addRequest.getId()).eq("status", "0"));
        if (count > 0) {
            baseResponse.setCode(400);
            baseResponse.setMsg("该公告已被置顶");
            return baseResponse;
        }

        //如果公司置顶公告数量大于1
        if (topNotice(addRequest.getUserOrgId()) >= 1) {
            baseResponse.setCode(400);
            baseResponse.setMsg("只能有一条置顶公告");
            return baseResponse;
        }
        //修改公告为停用状态状态 停用后直接用顶置表查询顶置消息，所以直接停用掉公告
        TSysNotice tSysNotice = new TSysNotice();
        tSysNotice.setId(addRequest.getId());
        tSysNotice.setStatus("3");
        int update = tSysNoticeDao.updateById(tSysNotice);
        if (update > 0) {
            //添加顶置消息
            int insert = tSysNoticeTopDao.insert(tSysNoticeTop);
            if (insert > 0) {
                baseResponse.setMsg("置顶成功");
                return baseResponse;
            }
        }
        baseResponse.setMsg("置顶失败");
        return baseResponse;
    }

    @Override
    public BaseResponse<TSysNotice> cancelTop(TSysNotice addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        this.update(new UpdateWrapper<TSysNoticeTop>().eq("notice_id", addRequest.getId()).set("status", "1"));
        TSysNotice tSysNotice = new TSysNotice();
        tSysNotice.setId(addRequest.getId());
        tSysNotice.setStatus("0");
        int update = tSysNoticeDao.updateById(tSysNotice);
        if (update > 0) {
            baseResponse.setMsg("取消成功");
            return baseResponse;
        }
        baseResponse.setMsg("取消失败");
        return baseResponse;
    }

    public Integer topNotice(String orgId) {
        //获取用户所有父级公司ID;
        SysOrg orgOrg = sysOrgDao.selectById(orgId);
        String orgIds = orgOrg.getParentIds() + "," + orgId;
        String[] split = orgIds.split(",");
        //查看当前用户的父级公司是否有顶置消息
        Integer top = tSysNoticeTopDao.selectCount(new QueryWrapper<TSysNoticeTop>().in("org_id", split).eq("status", "0"));
        return top;
    }


}
