package com.testor.module.safe.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 隐患巡检排查标准对象 t_safe_hazard_standard
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:45
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_standard")
@ApiModel(value = "TSafeHazardStandard对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardStandard extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 级别分类（总部/区域公司/基层粮库）
     */
    @ApiModelProperty(value = "级别分类（总部/区域公司/基层粮库）")

    @TableField("level_type")
    private String levelType;
    /**
     * 标准分类
     */
    @ApiModelProperty(value = "标准分类")

    @TableField("standard_type")
    private String standardType;

    /**
     * 标准分类（standard_type -> 子级）
     */
    @ApiModelProperty(value = "标准分类（standard_type -> 子级）")

    @TableField("standard_child")
    private String standardChild;

    /**
     * 标准名称
     */
    @ApiModelProperty(value = "标准名称")

    @TableField("standard_name")
    private String standardName;
    /**
     * 单位名称（当前登录用户所属机构id）
     */
    @ApiModelProperty(value = "单位名称（当前登录用户所属机构id）")

    @TableField("org_id")
    private String orgId;
    /**
     * 标准状态（0-禁用/1-现行/2-废止  执行流程改变状态）
     */
    @ApiModelProperty(value = "标准状态（0-禁用/1-现行/2-废止  执行流程改变状态）")

    @TableField("standard_status")
    private String standardStatus;


    @ApiModelProperty(value = "标准分类类型（0-设备；1-空间；2-管理内页）")
    @TableField("standard_type_level")
    private String standardTypeLevel;

    @ApiModelProperty(value = "级别")
    @TableField("\"level\"")
    private String level;

    @TableField(exist = false)
    @ApiModelProperty(value = "企业名称")
    private String orgName;

    @ApiModelProperty(value = "-1、不存在接收对象，0：所有人，1-代表接收人、2代表组织结构")
    @TableField("receiver_type")
    private String receiverType;


    @ApiModelProperty(value = "接收对象：可为人，组织机构，根据receiver_type确定")
    @TableField("receiver_obj")
    private String receiverObj;


    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String LEVEL_TYPE = "level_type";
    public static final String STANDARD_TYPE = "standard_type";
    public static final String STANDARD_NAME = "standard_name";
    public static final String ORG_ID = "org_id";
    public static final String STANDARD_STATUS = "standard_status";
    public static final String STANDARD_CHILD = "standard_child";


}
