package com.testor.module.safeCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.safeCheck.dao.TSafeCheckOrgDao;
import com.testor.module.safeCheck.model.domain.TSafeCheckOrg;
import com.testor.module.safeCheck.service.TSafeCheckOrgService;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.testor.module.sys.service.NewSysOrgService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 安全检查计划和被检查机构关系Service业务层处理
 * 
 * @author rsq
 * @date 2024-09-03 08:04:16
 */
@Service
public class TSafeCheckOrgServiceImpl extends SuperServiceImpl<TSafeCheckOrgDao, TSafeCheckOrg> implements TSafeCheckOrgService
{
    @Autowired(required = false)
    private TSafeCheckOrgDao tSafeCheckOrgDao;

    @Autowired(required = false)
    private NewSysOrgService sysOrgService;

    @Override
    public List<TSafeCheckOrg> getListByPlanId(String PlanId) {
        List<TSafeCheckOrg> list = this.list(new LambdaQueryWrapper<TSafeCheckOrg>().select(TSafeCheckOrg::getPlanId,TSafeCheckOrg::getCheckOrgId).eq(TSafeCheckOrg::getPlanId, PlanId));
        return list;
    }
}
