/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.datetime;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SystemClockHelper {
    private static final String THREAD_NAME = "SYSTEM.CLOCK";
    private static final SystemClockHelper MILLIS_CLOCK = new SystemClockHelper(1L);
    private final long precision;
    private final AtomicLong now;

    private SystemClockHelper(long precision) {
        this.precision = precision;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduleClockUpdating();
    }

    public static SystemClockHelper millisClock() {
        return MILLIS_CLOCK;
    }

    private void scheduleClockUpdating() {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(3, runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> this.now.set(System.currentTimeMillis()), this.precision, this.precision, TimeUnit.MILLISECONDS);
    }

    public long now() {
        return this.now.get();
    }
}

