/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.service.impl;

import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.service.TfwTaskService;
import com.tongtech.tfw.workflow.service.dto.TaskCompleteParams;
import com.tongtech.tfw.workflow.service.dto.TaskServiceResult;
import io.jsonwebtoken.lang.Collections;
import java.util.HashMap;
import org.flowable.engine.TaskService;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TfwTaskServiceImpl
implements TfwTaskService {
    @Autowired
    private TaskService taskService;

    @Override
    public TaskServiceResult completeTask(TaskCompleteParams taskCompleteParams) {
        if (ObjectHelper.isEmpty((Object)taskCompleteParams) || taskCompleteParams.checkMiss()) {
            return TaskServiceResult.builder().code("\u5931\u8d25,\u7f3a\u5c11\u4efb\u52a1\u53c2\u6570").result(TaskCompleteParams.check(taskCompleteParams)).build();
        }
        if (ObjectHelper.isEmpty(taskCompleteParams.getVars()) || Collections.isEmpty(taskCompleteParams.getVars())) {
            taskCompleteParams.setVars(new HashMap<String, Object>());
        }
        taskCompleteParams.getVars().put("executor", taskCompleteParams.getUserId());
        taskCompleteParams.getVars().put("executorOrgId", taskCompleteParams.getOrgId());
        taskCompleteParams.getVars().put("bizKeyId", taskCompleteParams.getBizId());
        String taskId = taskCompleteParams.getTaskId();
        Task task = this.getRuTask(taskId);
        if (ObjectHelper.isNotEmpty((Object)task.getDelegationState()) && DelegationState.PENDING == task.getDelegationState()) {
            this.addComments(taskId, taskCompleteParams.getComment());
            this.taskService.setVariablesLocal(taskId, taskCompleteParams.getVars());
            this.taskService.resolveTask(taskId, taskCompleteParams.getVars());
            return TaskServiceResult.builder().code("\u59d4\u6258\u4efb\u52a1\u6210\u529f").result(taskId).build();
        }
        this.addComments(taskId, taskCompleteParams.getComment());
        this.taskService.setVariablesLocal(taskId, taskCompleteParams.getVars());
        this.taskService.complete(taskId, new HashMap(), taskCompleteParams.getVars());
        return TaskServiceResult.builder().code("\u4efb\u52a1\u5b8c\u6210\u6210\u529f").result(taskId).build();
    }

    @Override
    public TaskServiceResult claimTask(String taskId, String userId) {
        this.taskService.claim(taskId, userId);
        return TaskServiceResult.builder().code("\u4efb\u52a1\u7b7e\u6536\u6210\u529f").result(taskId + "-" + userId).build();
    }

    @Override
    public TaskServiceResult claimAndCompleteTask(TaskCompleteParams taskCompleteParams) {
        this.claimTask(taskCompleteParams.getTaskId(), taskCompleteParams.getUserId());
        return this.completeTask(taskCompleteParams);
    }

    @Override
    public Task getRuTask(String taskId) {
        return (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
    }

    private void addComments(String taskId, String comment) {
        if (!StringHelper.isBlank((CharSequence)taskId) && !StringHelper.isBlank((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, null, comment);
        }
    }
}

