/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.util;

import com.tongweb.commons.adapter.WebListenerAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;

public class WebServerFactoryUtils {
    private WebListenerAdapter adapter;
    private AbstractServletWebServerFactory servletWebServerFactory;
    private Method getWebListenerMethod = null;

    public WebServerFactoryUtils() {
    }

    public WebServerFactoryUtils(AbstractServletWebServerFactory servletWebServerFactory, WebListenerAdapter adapter) {
        this.adapter = adapter;
        this.servletWebServerFactory = servletWebServerFactory;
    }

    public WebServerFactoryUtils setFactory(AbstractServletWebServerFactory servletWebServerFactory) {
        this.servletWebServerFactory = servletWebServerFactory;
        return this;
    }

    public WebServerFactoryUtils setAdapter(WebListenerAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public void done() {
        if (this.check()) {
            this.adapter.addWebListeners(this.getWebListeners());
        }
    }

    private boolean check() {
        Method getWebListenerClassNames = WebServerFactoryUtils.getMethodWithSuper(this.servletWebServerFactory.getClass(), "getWebListenerClassNames", new Class[0]);
        if (getWebListenerClassNames != null) {
            this.getWebListenerMethod = getWebListenerClassNames;
            return true;
        }
        return false;
    }

    private Set<String> getWebListeners() {
        if (this.getWebListenerMethod == null) {
            return Collections.emptySet();
        }
        try {
            this.getWebListenerMethod.setAccessible(true);
            return (Set)this.getWebListenerMethod.invoke((Object)this.servletWebServerFactory, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    private static Method getMethodWithSuper(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

