/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.file.controller;

import com.testor.biz.file.model.dto.FileDTO;
import com.testor.biz.sys.file.util.MinioUtilS;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import io.minio.MinioClient;
import io.minio.RemoveObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(value="Minio", tags={"\u6587\u4ef6\u4e0a\u4f20\u4e0b\u8f7d"})
public class MinioController {
    private static final Logger log = LoggerFactory.getLogger(MinioController.class);
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioUtilS minioUtilS;
    @Value(value="${minio.endpoint}")
    private String address;
    @Value(value="${minio.bucket}")
    private String bucketName;
    @Value(value="${minio.accessKey}")
    private String accessKey;
    @Value(value="${minio.secretKey}")
    private String secretKey;

    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20", notes="upload")
    @PostMapping(value={"/upload"})
    public BaseResponse<List> upload(@RequestParam MultipartFile[] file) throws Exception {
        BaseResponse baseResponse = new BaseResponse();
        List<FileDTO> upload = this.minioUtilS.upload(file);
        baseResponse.setData(upload);
        return baseResponse;
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="download")
    @GetMapping(value={"/download"})
    public ResponseEntity<byte[]> download(@RequestParam String fileName) {
        return this.minioUtilS.download(fileName);
    }

    @GetMapping(value={"/delete"})
    public BaseResponse<String> delete(String fileName) {
        BaseResponse response = new BaseResponse();
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(fileName)).build());
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        response.setMsg("\u5220\u9664\u6210\u529f");
        return response;
    }
}

