/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.valves;

import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.Response;
import com.tongweb.container.valves.ValveBase;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import java.io.IOException;
import javax.servlet.ServletException;

public class ManageFilterValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(ManageFilterValve.class);
    private String manageContextPath;
    private String[] accessIpList = new String[0];
    private String[] blockedIpList = new String[0];

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String requestContextPath = request.getServletPath();
        if (requestContextPath.startsWith(this.manageContextPath)) {
            String realIP;
            if (log.isDebugEnabled()) {
                log.debug(requestContextPath + " is a manage filter valve");
            }
            if ((realIP = ManageFilterValve.getRealIP(request)) != null && !realIP.isEmpty()) {
                if (this.isAllowed(realIP)) {
                    this.getNext().invoke(request, response);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug(realIP + " is not allowed to access the manager page");
                }
                response.sendError(403);
                return;
            }
        }
        this.getNext().invoke(request, response);
    }

    public boolean isAllowed(String realIp) {
        if (this.accessIpList.length == 0 && this.blockedIpList.length == 0) {
            return true;
        }
        if (this.accessIpList.length != 0) {
            for (int i = 0; i < this.accessIpList.length; ++i) {
                if (!ManageFilterValve.checkIPMatching(this.accessIpList[i], realIp)) continue;
                return true;
            }
            return false;
        }
        if (this.blockedIpList.length != 0) {
            for (int i = 0; i < this.blockedIpList.length; ++i) {
                if (!ManageFilterValve.checkIPMatching(this.blockedIpList[i], realIp)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean checkIPMatching(String pattern, String address) {
        String[] mask = pattern.split("\\.");
        String[] ip_address = address.split("\\.");
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i].equals("*") || mask[i].equals(ip_address[i])) continue;
            if (mask[i].contains("-")) {
                short min = Short.parseShort(mask[i].split("-")[0]);
                short max = Short.parseShort(mask[i].split("-")[1]);
                short ip = Short.parseShort(ip_address[i]);
                if (ip >= min && ip <= max) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String getRealIP(Request request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) && ip.indexOf(",") != -1) {
            ip = ip.split(",")[0];
        }
        if (ip == null || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.contains(",")) {
            String[] ipArray = ip.split(",");
            ip = ipArray[0];
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public String getManageContextPath() {
        return this.manageContextPath;
    }

    public void setManageContextPath(String manageContextPath) {
        this.manageContextPath = manageContextPath;
    }

    public String[] getAccessIpList() {
        return this.accessIpList;
    }

    public void setAccessIpList(String[] accessIpList) {
        if (accessIpList != null && accessIpList.length > 0) {
            this.accessIpList = accessIpList;
        }
    }

    public void setAccessIpList(String accessIpList) {
        if (accessIpList != null && !accessIpList.trim().isEmpty()) {
            this.accessIpList = accessIpList.split(",");
        }
    }

    public String[] getBlockedIpList() {
        return this.blockedIpList;
    }

    public void setBlockedIpList(String[] blockedIpList) {
        if (blockedIpList != null && blockedIpList.length > 0) {
            this.blockedIpList = blockedIpList;
        }
    }

    public void setBlockedIpList(String blockedIpList) {
        if (blockedIpList != null && !blockedIpList.trim().isEmpty()) {
            this.blockedIpList = blockedIpList.split(",");
        }
    }
}

