/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.exception;

import com.alibaba.excel.exception.ExcelAnalysisException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.tongtech.tfw.backend.common.constants.enumeration.ApiStatusCodeEnum;
import com.tongtech.tfw.backend.common.constants.enumeration.HttpStatusCodeEnum;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.exceptions.ServiceException;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.response.ResponseUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

public class GeneralExceptionHandler
extends AbstractHandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final ModelAndView MODEL_VIEW_INSTANCE = new ModelAndView();

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            if (ex instanceof ApiException) {
                this.handleApi((ApiException)ex, request, response);
            } else if (ex instanceof ServiceException) {
                this.handleService((ServiceException)ex, request, response);
            } else if (ex instanceof HttpRequestMethodNotSupportedException) {
                this.handleHttpRequestMethodNotSupported((HttpRequestMethodNotSupportedException)ex, request, response);
            } else if (ex instanceof HttpMediaTypeNotSupportedException) {
                this.handleHttpMediaTypeNotSupported((HttpMediaTypeNotSupportedException)ex, request, response);
            } else if (ex instanceof HttpMediaTypeNotAcceptableException) {
                this.handleHttpMediaTypeNotAcceptable((HttpMediaTypeNotAcceptableException)ex, request, response);
            } else if (ex instanceof MissingPathVariableException) {
                this.handleMissingPathVariable((MissingPathVariableException)ex, request, response);
            } else if (ex instanceof MissingServletRequestParameterException) {
                this.handleMissingServletRequestParameter((MissingServletRequestParameterException)ex, request, response);
            } else if (ex instanceof ServletRequestBindingException) {
                this.handleServletRequestBindingException((ServletRequestBindingException)ex, request, response);
            } else if (ex instanceof ConversionNotSupportedException) {
                this.handleConversionNotSupported((ConversionNotSupportedException)ex, request, response);
            } else if (ex instanceof TypeMismatchException) {
                this.handleTypeMismatch((TypeMismatchException)ex, request, response);
            } else if (ex instanceof HttpMessageNotReadableException) {
                this.handleHttpMessageNotReadable((HttpMessageNotReadableException)ex, request, response);
            } else if (ex instanceof HttpMessageNotWritableException) {
                this.handleHttpMessageNotWritable((HttpMessageNotWritableException)ex, request, response);
            } else if (ex instanceof MethodArgumentNotValidException) {
                this.handleMethodArgumentNotValidException((MethodArgumentNotValidException)ex, request, response);
            } else if (ex instanceof MissingServletRequestPartException) {
                this.handleMissingServletRequestPartException((MissingServletRequestPartException)ex, request, response);
            } else if (ex instanceof BindException) {
                this.handleBindException((BindException)ex, request, response);
            } else if (ex instanceof NoHandlerFoundException) {
                this.handleNoHandlerFoundException((NoHandlerFoundException)ex, request, response);
            } else if (ex instanceof AsyncRequestTimeoutException) {
                this.handleAsyncRequestTimeoutException((AsyncRequestTimeoutException)ex, request, response);
            } else if (ex instanceof ConstraintViolationException) {
                this.handleConstraintViolationException((ConstraintViolationException)ex, request, response);
            } else if (ex instanceof BusinessException) {
                this.handleBusinessException((BusinessException)ex, request, response);
            } else if (ex instanceof ExcelAnalysisException) {
                this.handleExcelAnalysisException((ExcelAnalysisException)ex, request, response);
            } else {
                this.handleException(ex, request, response);
            }
        }
        catch (Exception var6) {
            Exception handlerException = var6;
            log.error("Handling of [" + ex.getClass().getName() + "] resulted in Exception", (Throwable)handlerException);
        }
        if (response.getStatus() < 500) {
            log.info("Info: doResolveInfo ", (Throwable)ex);
        } else {
            log.error("Error: doResolveException {}", (Object)ex.getCause().getMessage(), (Object)ex);
        }
        return MODEL_VIEW_INSTANCE;
    }

    protected void handleApi(ApiException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, ex.getResponseInfo(), (Exception)ex);
    }

    protected void handleService(ServiceException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, ex.getResponseInfo(), (Object)ex.getResponseInfo());
    }

    protected void handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.METHOD_NOT_ALLOWED, (Exception)ex);
    }

    protected void handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.UNSUPPORTED_MEDIA_TYPE, (Exception)ex);
    }

    protected void handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.NOT_ACCEPTABLE, (Exception)ex);
    }

    protected void handleMissingPathVariable(MissingPathVariableException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.INTERNAL_SERVER_ERROR, (Exception)ex);
    }

    protected void handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
    }

    protected void handleServletRequestBindingException(ServletRequestBindingException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
    }

    protected void handleConversionNotSupported(ConversionNotSupportedException ex, HttpServletRequest request, HttpServletResponse response) {
        this.sendServerError((Exception)ex, request, response);
    }

    protected void handleTypeMismatch(TypeMismatchException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
    }

    protected void handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpServletRequest request, HttpServletResponse response) {
        if (ex.getCause() instanceof JsonParseException) {
            ResponseUtil.response(request, response, ApiStatusCodeEnum.JSON_FORMAT_ERROR, (Exception)ex);
        } else if (ex.getCause() instanceof MismatchedInputException) {
            ResponseUtil.response(request, response, ApiStatusCodeEnum.JSON_FORMAT_ERROR, (Exception)ex);
        } else {
            ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
        }
    }

    protected void handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpServletRequest request, HttpServletResponse response) {
        this.sendServerError((Exception)ex, request, response);
    }

    protected void handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
    }

    protected void handleMissingServletRequestPartException(MissingServletRequestPartException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
    }

    protected void handleBindException(BindException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
    }

    protected void handleNoHandlerFoundException(NoHandlerFoundException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.NOT_FOUND, (Exception)ex);
    }

    protected void handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.SERVICE_UNAVAILABLE, (Exception)ex);
    }

    protected void handleExcelAnalysisException(ExcelAnalysisException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, ResponseInfo.builder().code(400).msg(ex.getMessage()).build(), (Exception)ex);
    }

    protected void handleConstraintViolationException(ConstraintViolationException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.BAD_REQUEST, (Exception)ex);
    }

    protected void handleException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.INTERNAL_SERVER_ERROR, ex);
    }

    protected void sendServerError(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, HttpStatusCodeEnum.INTERNAL_SERVER_ERROR, ex);
    }

    protected void handleBusinessException(BusinessException ex, HttpServletRequest request, HttpServletResponse response) {
        ResponseUtil.response(request, response, ResponseInfo.builder().code(ex.getCode()).msg(ex.getMessage()).build(), (Exception)ex);
    }
}

