/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.tongtech.tfw.backend.common.models.jwt.JwtInfos;
import com.tongtech.tfw.backend.core.helper.CollectionHelper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import com.tongtech.tfw.backend.core.helper.security.RSA256Helper;
import com.tongtech.tfw.backend.core.helper.security.rsa256.RSA256Key;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.TextCodec;
import io.jsonwebtoken.impl.compression.DefaultCompressionCodecResolver;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;

public class JwtHelper {
    private static final int COUNT_2 = 2;
    private static final CompressionCodecResolver codecResolver = new DefaultCompressionCodecResolver();

    private JwtHelper() {
    }

    public static String issueJwt(String id, String subject, String issuer, Long period, String roles, String permissions, SignatureAlgorithm algorithm) {
        return JwtHelper.issueJwt(id, subject, issuer, period, roles, permissions, algorithm, "377b82a74bc4a03c");
    }

    public static String issueJwt(String id, String subject, String issuer, Long period, String roles, String permissions, SignatureAlgorithm algorithm, String tokenSecret) {
        long currentTimeMillis = System.currentTimeMillis();
        byte[] secretKeyBytes = DatatypeConverter.parseBase64Binary((String)tokenSecret);
        JwtBuilder jwtBuilder = Jwts.builder();
        if (!StringHelper.isEmpty((CharSequence)id)) {
            jwtBuilder.setId(id);
        }
        if (!StringHelper.isEmpty((CharSequence)subject)) {
            jwtBuilder.setSubject(subject);
        }
        if (!StringHelper.isEmpty((CharSequence)issuer)) {
            jwtBuilder.setIssuer(issuer);
        }
        jwtBuilder.setIssuedAt(new Date(currentTimeMillis));
        if (null != period) {
            jwtBuilder.setExpiration(new Date(currentTimeMillis + period * 1000L));
        }
        if (!StringHelper.isEmpty((CharSequence)roles)) {
            jwtBuilder.claim("roles", (Object)roles);
        }
        if (!StringHelper.isEmpty((CharSequence)permissions)) {
            jwtBuilder.claim("perms", (Object)permissions);
        }
        jwtBuilder.compressWith(CompressionCodecs.DEFLATE);
        jwtBuilder.signWith(algorithm, secretKeyBytes);
        return jwtBuilder.compact();
    }

    public static JwtInfos parseJwt(String jwt, String appKey) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)appKey)).parseClaimsJws(jwt).getBody();
        JwtInfos jwtAccount = JwtInfos.builder().tokenId(claims.getId()).userId(claims.getSubject()).issuer(claims.getIssuer()).issuedAt(claims.getIssuedAt()).audience(claims.getAudience()).roles((String)claims.get("roles", String.class)).perms((String)claims.get("perms", String.class)).build();
        return jwtAccount;
    }

    public static String issueJwtAuth0(String id, String subject, String claim, String issuer, String clients, Long period) {
        long currentTimeMillis = System.currentTimeMillis();
        RSA256Key rsa256Key = RSA256Helper.getRSA256Key();
        String jwt = JWT.create().withJWTId(id).withSubject(subject).withIssuer(issuer).withClaim("user_info", claim).withIssuedAt(new Date(currentTimeMillis)).withExpiresAt(new Date(currentTimeMillis + period * 1000L)).withAudience(new String[]{(String)ObjectHelper.defaultIfNull((Object)clients, (Object)"test")}).sign(Algorithm.HMAC256((String)"377b82a74bc4a03c"));
        return jwt;
    }

    public static JwtInfos parseJwtAuth0(String jwt, String issuer) {
        RSA256Key rsa256Key = RSA256Helper.getRSA256Key();
        JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)"377b82a74bc4a03c")).withIssuer(new String[]{issuer}).build();
        DecodedJWT claims = verifier.verify(jwt);
        JwtInfos jwtAccount = JwtInfos.builder().tokenId(claims.getId()).userId(claims.getSubject()).issuer(claims.getIssuer()).issuedAt(claims.getIssuedAt()).audience(claims.getAudience().stream().map(String::valueOf).collect(Collectors.joining(","))).userInfo(((Claim)claims.getClaims().get("user_info")).asString()).build();
        return jwtAccount;
    }

    public static String parseJwtPayload(String jwt) {
        String payload;
        Assert.hasText((String)jwt, (String)"JWT String argument cannot be null or empty.");
        String base64UrlEncodedHeader = null;
        String base64UrlEncodedPayload = null;
        String base64UrlEncodedDigest = null;
        int delimiterCount = 0;
        StringBuilder sb = new StringBuilder(128);
        for (char c : jwt.toCharArray()) {
            if (c == '.') {
                String token;
                CharSequence tokenSeq = Strings.clean((CharSequence)sb);
                String string = token = tokenSeq != null ? tokenSeq.toString() : null;
                if (delimiterCount == 0) {
                    base64UrlEncodedHeader = token;
                } else if (delimiterCount == 1) {
                    base64UrlEncodedPayload = token;
                }
                ++delimiterCount;
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (delimiterCount != 2) {
            String msg = "JWT strings must contain exactly 2 period characters. Found: " + delimiterCount;
            throw new MalformedJwtException(msg);
        }
        if (sb.length() > 0) {
            base64UrlEncodedDigest = sb.toString();
        }
        if (base64UrlEncodedPayload == null) {
            throw new MalformedJwtException("JWT string '" + jwt + "' is missing a body/payload.");
        }
        CompressionCodec compressionCodec = null;
        if (base64UrlEncodedHeader != null) {
            String origValue = TextCodec.BASE64URL.decodeToString(base64UrlEncodedHeader);
            Map<String, Object> m = JwtHelper.readValue(origValue);
            Object header = base64UrlEncodedDigest != null ? new DefaultJwsHeader(m) : new DefaultHeader(m);
            compressionCodec = codecResolver.resolveCompressionCodec((Header)header);
        }
        if (compressionCodec != null) {
            byte[] decompressed = compressionCodec.decompress(TextCodec.BASE64URL.decode(base64UrlEncodedPayload));
            payload = new String(decompressed, Strings.UTF_8);
        } else {
            payload = TextCodec.BASE64URL.decodeToString(base64UrlEncodedPayload);
        }
        return payload;
    }

    public static Map<String, Object> readValue(String val) {
        return (Map)JacksonHelper.readValue((String)val, Map.class);
    }

    public static Set<String> split(String str) {
        HashSet<String> set = new HashSet<String>();
        if (StringHelper.isEmpty((CharSequence)str)) {
            return set;
        }
        set.addAll(CollectionHelper.arrayToList((Object)str.split(",")));
        return set;
    }

    public static void main(String[] args) {
        String jwt = JwtHelper.issueJwtAuth0(IdHelper.getId32bit(), "1242684364872761344", "", "Token Issuer", "", 36000L);
        String token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJzdWIiOiIxMjQyNjg0MzY0ODcyNzYxMzQ0IiwiYXVkIjoidGVzdCIsImlzcyI6IlRva2VuIElzc3VlciIsImV4cCI6MTYxMTYwNDI0MCwiaWF0IjoxNjExNTY4MjQwLCJqdGkiOiIwOTI4MjM2OTA2OTc0NDgwOGJkMGFkZjQzZmVmNjEzNCJ9.Ehx7tVewYaR-zE8UhvMptkzIabVS7e8assbYVe78iNQ0TjYtZuoL8Ii1Pq0l4kDUxF69vts8kFHf1lEphZCH-s3prGS2fNKslnFKUdJK2GeGKCTVcvmg126w_hCHTjCr880sc5ECAfQsWg_r_ZEDQ7_5820RuBBDAa_gEKXLsmI";
        try {
            System.out.println(jwt);
            System.out.println(JwtHelper.parseJwtPayload(jwt));
            Thread.sleep(2000L);
            JwtInfos jwtInfos = JwtHelper.parseJwtAuth0(jwt, "Token Issuer");
            System.out.println(jwtInfos.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

