/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.response;

import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(ResponseWrapper.class);

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void writeJsonResponse(Object obj) {
        if (super.isCommitted()) {
            log.warn("Response is commit");
        } else {
            super.setContentType("application/json");
            super.setCharacterEncoding("UTF-8");
            try (PrintWriter writer = super.getWriter();){
                writer.print(JacksonHelper.toJson((Object)obj));
                writer.flush();
            }
            catch (IOException e) {
                log.warn("Error: Response print Json failed, stackTrace:", (Throwable)e);
            }
        }
    }
}

