package com.testor.ddd.safetyControl.domain.lecls.entity;

import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.RiskLeclsValDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.TSafeRiskLeclsRelationDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.TSafeRiskLeclsRelationDTOParam;
import com.tongtech.tfw.backend.common.exception.BusinessException;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeRiskLeclsRelationRepo {

    TSafeRiskLeclsRelationDTO insert(TSafeRiskLeclsRelationDTO riskLeclsRelationDTO);

    TSafeRiskLeclsRelationDTO updateById(TSafeRiskLeclsRelationDTO riskLeclsRelationDTO);

    TSafeRiskLeclsRelationDTO findById(String id);

    boolean deleteById(String id);

    List<TSafeRiskLeclsRelationDTO> listAllEntity(TSafeRiskLeclsRelationDTOParam param);

    List<TSafeRiskLeclsRelationDTO> saveOrUpdateBatch(List<TSafeRiskLeclsRelationDTO> riskLeclsRelationDTOList);

    boolean deleteRelationByType(Integer type);

    /**
     * 根据 lec/ls 计算 现实风险等级
     * @param leclsValDTO
     */
    TSafeRiskLeclsRelationDTO findLevelByLecls(RiskLeclsValDTO leclsValDTO) throws BusinessException;
}
