package com.testor.ddd.safetyControl.interfaces.model.vo.riskMap;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 风险地图元素对象 t_safe_risk_map_element
 * 
 * @author testor-framework
 * @date 2022-10-05 15:18:07
 */
@Data
public class TSafeRiskMapElementVO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;
/**
 * 风险地图id
 */
  @ApiModelProperty(value = "风险地图id")
  private String mapId;
/**
 * 空间id
 */
  @ApiModelProperty(value = "空间id")
  private String spaceId;

  /**
   * 空间id
   */
  @ApiModelProperty(value = "空间名称")
  private String spaceName;

/**
 * 现实风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)")
  private String realLevelId;
/**
 * 固有风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)")
  private String inherentLevelId;
/**
 * 责任部门
 */
  @ApiModelProperty(value = "责任部门")
  private String departmentId;

  @ApiModelProperty(value = "责任部门")
  private String departmentName;

/**
 * 责任人
 */
  @ApiModelProperty(value = "责任人")
  private String userId;

  /**
   * 责任人
   */
  @ApiModelProperty(value = "责任人")
  private String userName;

/**
 * 地图坐标信息
 */
  @ApiModelProperty(value = "地图坐标信息")
  private String mapJson;
/**
 * 固有风险等级编号
 */
  @ApiModelProperty(value = "固有风险等级编号")
  private String inherentLevelCode;
/**
 * 现实风险等级编号
 */
  @ApiModelProperty(value = "现实风险等级编号")
  private String realLevelCode;
  /**
   * 固有风险等级编号
   */
  @ApiModelProperty(value = "固有风险等级名称")
  private String inherentLevelName;
  /**
   * 现实风险等级编号
   */
  @ApiModelProperty(value = "现实风险等级名称")
  private String realLevelName;

  /**
   * 风险类型(1-现实风险；2-固有风险)
   */
  @ApiModelProperty(value = "风险类型(1-现实风险；2-固有风险)")
  private String levelType;
}
