package com.testor.module.accident.service;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.common.model.UpdateProcessStatusReq;
import com.testor.module.accident.model.domain.AccidentReport;
import com.testor.module.accident.model.excel.AccidentExport;
import com.testor.module.accident.model.req.*;
import com.testor.module.accident.model.resp.AccidentReportEditResp;
import com.testor.module.accident.model.resp.AccidentReportInsResp;
import com.testor.module.accident.model.resp.AccidentStatisticsResp;
import com.testor.module.accident.model.resp.ReportUnitResp;
import com.testor.module.accident.model.vo.AccidentReportVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 事故上报Service接口
 *
 * @author zhangyangfan@testor.com.cn
 * @date 2022-05-11 11:35:33
 */
public interface AccidentReportService extends SuperService<AccidentReport> {

    /**
     * 新增
     *
     * @param accidentReportInsReq
     * @return
     */
    AccidentReportInsResp insertAll(AccidentReportInsReq accidentReportInsReq) throws Exception;


    /**
     * 修改
     *
     * @param accidentReportEditReq
     * @return
     */
    AccidentReportEditResp updateAll(AccidentReportEditReq accidentReportEditReq) throws Exception;


    /**
     * *
     *
     * @description: 查询详情
     * @param: [id]
     * @return: com.testor.module.accident.model.vo.AccidentReportVO
     * @author zhangyangfan@testor.com.cn
     * @date: 2022/5/11 14:17
     */
    AccidentReportVO getInfo(String id) throws Exception;

    /**
     * @param updateProcessStatusReq
     * @description: 变更审批状态
     * @return: void
     * @author zhangyangfan@testor.com.cn
     * @date: 2022/5/11 14:18
     */
    void updateProcessStatus(UpdateProcessStatusReq updateProcessStatusReq) throws Exception;

    /**
     * @description: 获取当前登录人上报单位
     * @param:
     * @return:
     * @author zhangyangfan@testor.com.cn
     * @date: 2022/5/11 15:16
     */
    ReportUnitResp getReportUnit() throws Exception;

    /**
     * @param accidentStatisticsReq
     * @description: 获取事故统计数据
     * @param: []
     * @return: com.testor.module.accident.model.resp.AccidentStatisticsResp
     * @author zhangyangfan@testor.com.cn
     * @date: 2022/5/12 16:12
     */
    AccidentStatisticsResp getAccidentStatistics(AccidentStatisticsReq accidentStatisticsReq) throws Exception;

    /**
     * @description: excel导出
     * @param: [accidentReportExportReq]
     * @return: void
     * @author zhangyangfan@testor.com.cn
     * @date: 2022/5/16 16:02
     */
    List<AccidentExport> export(AccidentReportExportReq accidentReportExportReq) throws Exception;

    /**
     * @description: 查询条件
     * @param: [param]
     * @return: com.baomidou.mybatisplus.core.conditions.query.QueryWrapper<com.testor.module.accident.model.domain.AccidentReport>
     * @author zhangyangfan@testor.com.cn
     * @date: 2022/5/16 18:33
     */

    QueryWrapper<AccidentReport> queryCondition(AccidentReportQueryReq param) throws Exception;

    AccidentReportQueryReq queryConditions(AccidentReportExportReq param) throws Exception;

    /**
     * @description: 物理删除
     * @param: [id]
     * @return: void
     * @author zhangyangfan@testor.com.cn
     * @date: 2022/5/20 14:05
     */
    void physicsDelete(String id) throws Exception;

    String getCountByAccidentTime(Integer accidentTime,String orgId);

    List<AccidentReport> getAccidentReportByAccidentTime(Integer accidentTime,String orgId);

    /**
     * @description TODO 导出事故列表
     * @param response
     * @param request
     * @param accidentReportExportReq
     * @return void
     * @author qiao
     * @date 4/11/23 9:48 AM
     */
    void exports(HttpServletResponse response, HttpServletRequest request, AccidentReportExportReq accidentReportExportReq);
}
