package com.testor.module.contractor.ledger.service;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorLedger;
import com.testor.module.contractor.ledger.model.dto.LedgerTypeVo;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerDto;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 承包商台账Service接口
 * 
 * @author testor-framework
 * @date 2024-11-19 10:01:42
 */
public interface TContractorLedgerService extends SuperService<TContractorLedger> {

    /**
     * 添加承包商台账
     * @param addRequest
     * @return
     */
    TContractorLedger addContractorLedger(TContractorLedgerDto addRequest);

    /**
     * 根据id获取承包商台账
     * @param id
     * @return
     */
    TContractorLedgerDto getLedgerById(String id);

    /**
     * 分页查询承包商台账
     * @param param
     * @return
     */
    Page<TContractorLedger> pageList(TContractorLedgerParam param);

    /**
     * 修改承包商台账
     * @param updateRequest
     * @return
     */
    TContractorLedger updateEntity(TContractorLedgerDto updateRequest);

    List<LedgerTypeVo> getLedgerTypeVo(TContractorLedgerParam param);


    TContractorLedger findLedgerByName(String  name);
}
