package com.testor.module.contractor.ledger.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.ledger.dao.TContractorContractDao;
import com.testor.module.contractor.ledger.model.domain.TContractorContract;
import com.testor.module.contractor.ledger.service.TContractorContractService;
import com.testor.module.sys.service.NewSysFileService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * 承包商合同Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-19 10:20:52
 */
@Service
public class TContractorContractServiceImpl extends SuperServiceImpl<TContractorContractDao, TContractorContract> implements TContractorContractService
{
    @Autowired(required = false)
    private TContractorContractDao tContractorContractDao;

    @Autowired
    private NewSysFileService newSysFileService;

    @Override
    public List<TContractorContract> findByContractId(String contractId) {
        return this.list(new LambdaQueryWrapper<TContractorContract>().eq(TContractorContract::getContractorId, contractId));
    }
}
