package com.testor.module.contractor.manage.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import com.testor.module.contractor.manage.model.domain.TContractorBasicInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class ContractorInfoDTO extends TContractorBasicInfo {

  /**
   * 承包商名称
   */
  @ApiModelProperty(value = "承包商名称")
  private String contractorName;

  /**
   * 业务性质
   */
  @ApiModelProperty(value = "业务性质")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL)
  private String bizNatureId;

  /**
   * 项目名称（多个项目用逗号分隔）
   */
  @ApiModelProperty(value = "项目名称（多个项目用逗号分隔）")
  private String projectNames;

  /**
   * 所在省份
   */
  @ApiModelProperty(value = "所在省份")
  private String province;

  /**
   * 所在城市
   */
  @ApiModelProperty(value = "所在城市")
  private String city;

  /**
   * 地址
   */
  @ApiModelProperty(value = "地址")
  private String addr;

  /**
   * 注册日期
   */
  @ApiModelProperty(value = "注册日期")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date regDate;

  /**
   * 有效期
   */
  @ApiModelProperty(value = "有效期")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date validPeriod;

  /**
   * 承包商类型
   */
  @ApiModelProperty(value = "承包商类型")
  private String type;

}
