package com.testor.module.contractor.manage.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.manage.model.domain.TContractorBlacklist;
import com.testor.module.contractor.manage.model.dto.ContractorBlacklistDto;
import com.testor.module.contractor.manage.model.dto.TContractorBlacklistParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 承包商管理-考核评价-黑名单Service接口
 * 
 * @author testor-framework
 * @date 2024-12-01 11:15:44
 */
public interface TContractorBlacklistService extends SuperService<TContractorBlacklist> {

    Page<ContractorBlacklistDto> pageList(TContractorBlacklistParam queryRequest);
    void startProcess(TContractorBlacklistParam updateRequest);
    void completeProcess(TContractorBlacklistParam updateRequest);

    TContractorBlacklist getByContractorId(String contractorId);

    /**
     * 根据承包商id查询承包商是否进入黑名单
     * @param contractorId
     * @return
     */
    boolean existBlacklist(String contractorId);

    /**
     * 查询进入黑名单的承包商id集合
     * @return
     */
    List<String>  getBlacklistContractorIds();
}
