package com.testor.module.emergency.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 应急预案应急工作组及工作内容对象 t_contingency_plan_content
 * 
 * @author testor-framework
 * @date 2022-10-18 10:07:39
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contingency_plan_content")
@ApiModel(value = "TContingencyPlanContent对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContingencyPlanContent extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 应急预案id
 */
  @ApiModelProperty(value = "应急预案id")

  @TableField("plan_id")
  private String planId;
/**
 * 具体工作
 */
  @ApiModelProperty(value = "具体工作")

  @TableField("specific_work")
  private String specificWork;
/**
 * 主要工作
 */
  @ApiModelProperty(value = "主要工作")

  @TableField("ground_work")
  private String groundWork;
/**
 * 应急工作小组字典key
 */
  @ApiModelProperty(value = "应急工作小组字典key")

  @TableField("group_key")
  private String groupKey;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;

  public static final String PLAN_ID ="plan_id";
  public static final String SPECIFIC_WORK ="specific_work";
  public static final String GROUND_WORK ="ground_work";
  public static final String GROUP_KEY ="group_key";
  public static final String ID ="id";
  public static final String ORG_ID ="org_id";


}
