package com.testor.module.fives.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 5s工具运用改善案例对象 t_fives_tool_case
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_fives_tool_case")
@ApiModel(value = "TFivesToolCase对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TFivesToolCase extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 案例分类（字典配置）
     */
    @ApiModelProperty(value = "案例分类（字典配置）")

    @TableField("case_type")
    private String caseType;
    /**
     * 提案名称
     */
    @ApiModelProperty(value = "提案名称")

    @TableField("case_name")
    private String caseName;
    /**
     * 推荐理由
     */
    @ApiModelProperty(value = "推荐理由")

    @TableField("recommend_reason")
    private String recommendReason;
    /**
     * 问题描述
     */
    @ApiModelProperty(value = "问题描述")

    @TableField("problem_des")
    private String problemDes;
    /**
     * 改善说明
     */
    @ApiModelProperty(value = "改善说明")

    @TableField("improve_des")
    private String improveDes;
    /**
     * 改善前图片
     */
    @ApiModelProperty(value = "改善前图片")

    @TableField("image_1")
    private String image1;
    /**
     * 改善后图片
     */
    @ApiModelProperty(value = "改善后图片")

    @TableField("image_2")
    private String image2;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    @TableField("serial_number")
    private String serialNumber;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String CASE_TYPE = "case_type";
    public static final String CASE_NAME = "case_name";
    public static final String RECOMMEND_REASON = "recommend_reason";
    public static final String PROBLEM_DES = "problem_des";
    public static final String IMPROVE_DES = "improve_des";
    public static final String IMAGE_1 = "image_1";
    public static final String IMAGE_2 = "image_2";
    public static final String SERIAL_NUMBER = "serial_number";


}
