package com.testor.module.fives.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;


/**
 * 5s工具运用焦点课题对象 t_fives_tool_focus
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_fives_tool_focus")
@ApiModel(value = "TFivesToolFocus对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TFivesToolFocus extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 课程名称
     */
    @ApiModelProperty(value = "课程名称")

    @TableField("course_name")
    private String courseName;
    /**
     * 课题所属部门（当前登录用户所属企业部门）
     */
    @ApiModelProperty(value = "课题所属部门（当前登录用户所属企业部门）")

    @TableField("course_section")
    private String courseSection;
    /**
     * 课题负责人
     */
    @ApiModelProperty(value = "课题负责人")

    @TableField("course_principal")
    private String coursePrincipal;
    /**
     * 团队人数
     */
    @ApiModelProperty(value = "团队人数", example = "0")

    @TableField("team_size")
    private Long teamSize;
    /**
     * 课题方向（字典配置）
     */
    @ApiModelProperty(value = "课题方向（字典配置）")

    @TableField("course_direction")
    private String courseDirection;
    /**
     * 改善对象
     */
    @ApiModelProperty(value = "改善对象")

    @TableField("focus_obj")
    private String focusObj;
    /**
     * 计划开始时间
     */
    @ApiModelProperty(value = "计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField("begin_date")
    private Date beginDate;
    /**
     * 计划结束时间
     */
    @ApiModelProperty(value = "计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField("end_date")
    private Date endDate;
    /**
     * 推进理由
     */
    @ApiModelProperty(value = "推进理由")

    @TableField("boost_reason")
    private String boostReason;
    /**
     * 重点推进内容
     */
    @ApiModelProperty(value = "重点推进内容")

    @TableField("boost_content")
    private String boostContent;
    /**
     * 预期目标
     */
    @ApiModelProperty(value = "预期目标")

    @TableField("expect_target")
    private String expectTarget;
    /**
     * 最终结果
     */
    @ApiModelProperty(value = "最终结果")

    @TableField("last_result")
    private String lastResult;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    @TableField("serial_number")
    private String serialNumber;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String COURSE_NAME = "course_name";
    public static final String COURSE_SECTION = "course_section";
    public static final String COURSE_PRINCIPAL = "course_principal";
    public static final String TEAM_SIZE = "team_size";
    public static final String COURSE_DIRECTION = "course_direction";
    public static final String FOCUS_OBJ = "focus_obj";
    public static final String BEGIN_DATE = "begin_date";
    public static final String END_DATE = "end_date";
    public static final String BOOST_REASON = "boost_reason";
    public static final String BOOST_CONTENT = "boost_content";
    public static final String EXPECT_TARGET = "expect_target";
    public static final String LAST_RESULT = "last_result";
    public static final String SERIAL_NUMBER = "serial_number";


}
