package com.testor.module.fives.service;


import com.testor.biz.sys.dict.data.model.dto.SysDictDataListResponse;
import com.testor.module.fives.model.dto.TFivesStandardDelParam;
import com.testor.module.fives.model.excel.TFivesStandardReport;
import com.testor.module.fives.model.domain.TFivesStandard;
import com.testor.module.fives.model.dto.TFivesStandardDTO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;
import java.util.Map;

/**
 * 5s标准验收管理Service接口
 *
 * @author testor-framework
 * @date 2022-07-11 14:00:17
 */
public interface TFivesStandardService extends SuperService<TFivesStandard> {

    /**
     * 5s标准验收管理 新增
     *
     * @param tFivesStandardDTO 新增参数
     */
    BaseResponse<String> add(TFivesStandardDTO tFivesStandardDTO);

    /**
     * 5s标准验收管理 修改
     *
     * @param tFivesStandardDTO 修改参数
     */
    BaseResponse<String> update(TFivesStandardDTO tFivesStandardDTO);

    /**
     * 5s导出
     *
     * @param dsName      .
     * @param datasetName .
     * @param parameters  .
     * @return .
     */
    List<TFivesStandardReport> exportFiveStandard(String dsName, String datasetName, Map<String, Object> parameters);


    boolean delSubOption(String fiveStandardId);

    BaseResponse<String> deleteEntity(TFivesStandardDelParam deleteRequest);

    String getDictValue(List<SysDictDataListResponse> list, String type, Map<String, List<SysDictDataListResponse>> map, String dictType);

}
