package com.testor.module.hazard.controller;

import java.util.ArrayList;
import java.util.List;

import com.testor.module.hazard.model.domain.THazardAssessmentDetails;
import com.testor.module.hazard.model.dto.THazardAssessmentDetailsDelParam;
import com.testor.module.hazard.model.dto.THazardAssessmentDetailsParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.service.THazardAssessmentDetailsService;

/**
 * 危险作业风险分析明细Controller
 *
 * @author testor-framework
 * @date 2024-12-24 18:46:00
 */
@RestController
@RequestMapping("/assessment/details")
@Api(value = "THazardAssessmentDetails", tags = "危险作业风险分析明细")
@Slf4j
public class THazardAssessmentDetailsController extends SuperController
{
    @Autowired
    private THazardAssessmentDetailsService tHazardAssessmentDetailsService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业风险分析明细", notes = "Add THazardAssessmentDetails")
	@PostMapping(value = "/add")
	public BaseResponse<THazardAssessmentDetails>addEntity(@RequestBody THazardAssessmentDetails addRequest) {
		BaseResponse<THazardAssessmentDetails> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            THazardAssessmentDetails data=BeanHelper.beanToBean(addRequest,  THazardAssessmentDetails.class);
			data.setId(id);
			boolean result= tHazardAssessmentDetailsService.save(data);
			if(result){
                THazardAssessmentDetails newEntity = new THazardAssessmentDetails();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业风险分析明细 ", notes = "Get THazardAssessmentDetails By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardAssessmentDetails> getById(String id){
		BaseResponse<THazardAssessmentDetails> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            THazardAssessmentDetails data= tHazardAssessmentDetailsService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业风险分析明细 ", notes = "Update THazardAssessmentDetails By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardAssessmentDetails updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardAssessmentDetails data=BeanHelper.beanToBean(updateRequest, THazardAssessmentDetails.class);
			boolean result= tHazardAssessmentDetailsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业风险分析明细 ", notes = "delete THazardAssessmentDetails By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardAssessmentDetailsDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardAssessmentDetails data= new THazardAssessmentDetails();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardAssessmentDetailsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业风险分析明细", notes = "delete THazardAssessmentDetails by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardAssessmentDetailsDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardAssessmentDetails> tHazardAssessmentDetailsList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardAssessmentDetails data= new THazardAssessmentDetails();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardAssessmentDetailsList.add(data);
			}
			boolean result = tHazardAssessmentDetailsService.updateBatchById(tHazardAssessmentDetailsList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业风险分析明细 分页列表", notes = "List THazardAssessmentDetails with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardAssessmentDetails>>listEntity(THazardAssessmentDetailsParam param){
		BaseResponse<BaseResponseList<THazardAssessmentDetails>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardAssessmentDetails> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardAssessmentDetails> queryWrapper=this.createQuery(param);
		Page<THazardAssessmentDetails> resultList= tHazardAssessmentDetailsService.page(resultPage,queryWrapper);
		BaseResponseList<THazardAssessmentDetails> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业风险分析明细 列表", notes = "List THazardAssessmentDetails all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardAssessmentDetails>>listAllEntity(THazardAssessmentDetailsParam param){
		BaseResponse<BaseResponseList<THazardAssessmentDetails>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardAssessmentDetails> queryWrapper=this.createQuery(param);
		List<THazardAssessmentDetails> resultList=tHazardAssessmentDetailsService.list(queryWrapper);
		BaseResponseList<THazardAssessmentDetails> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardAssessmentDetails> createQuery(THazardAssessmentDetailsParam queryParam){
		QueryWrapper<THazardAssessmentDetails> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getAssessmentId())){
			queryWrapper.eq(THazardAssessmentDetails.ASSESSMENT_ID,queryParam.getAssessmentId());
		}
		if(StringHelper.isNotEmpty(queryParam.getStage())){
			queryWrapper.eq(THazardAssessmentDetails.STAGE,queryParam.getStage());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkStep())){
			queryWrapper.eq(THazardAssessmentDetails.WORK_STEP,queryParam.getWorkStep());
		}
		if(StringHelper.isNotEmpty(queryParam.getMajorRisk())){
			queryWrapper.eq(THazardAssessmentDetails.MAJOR_RISK,queryParam.getMajorRisk());
		}
		if(StringHelper.isNotEmpty(queryParam.getConsequence())){
			queryWrapper.eq(THazardAssessmentDetails.CONSEQUENCE,queryParam.getConsequence());
		}
		if(StringHelper.isNotEmpty(queryParam.getControlMeasures())){
			queryWrapper.eq(THazardAssessmentDetails.CONTROL_MEASURES,queryParam.getControlMeasures());
		}
		if(StringHelper.isNotEmpty(queryParam.getIsSatisfied())){
			queryWrapper.eq(THazardAssessmentDetails.IS_SATISFIED,queryParam.getIsSatisfied());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardAssessmentDetails.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardAssessmentDetails.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardAssessmentDetails.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
