package com.testor.module.hazard.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.testor.module.hazard.model.domain.TContractorAccessLog;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

/**
 * 承包商准入管理访问日志Mapper接口
 *
 * @author testor-framework
 * @date 2025-01-20
 */
@Mapper
public interface TContractorAccessLogDao extends BaseMapper<TContractorAccessLog>, SuperDao<TContractorAccessLog> {

    /**
     * 获取最大批次
     * @param contractorAllowId
     * @return
     */
    @Select("SELECT MAX(CAST(batch AS INTEGER)) \n" +
            "FROM t_contractor_access_log \n" +
            "WHERE contractor_allow_id = #{contractorAllowId}")
    String getMaxBatch(@Param("contractorAllowId") String contractorAllowId);

    @Update("update t_contractor_access_log set status ='1' where contractor_allow_id = #{contractorAllowId}")
    void updateStatus(@Param("contractorAllowId") String contractorAllowId);




}

