package com.testor.module.hazard.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * 承包商准入管理访问日志审批表对象 t_contractor_access_log_approval
 *
 * @author testor-framework
 * @date 2025-01-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_access_log_approval")
@ApiModel(value = "TContractorAccessLogApproval对象", description = "承包商准入管理访问日志审批表")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAccessLogApproval extends SuperModel {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 准入管理对象ID
     */
    @ApiModelProperty(value = "准入管理对象ID")
    @TableField("contractor_allow_id")
    private String contractorAllowId;

    /**
     * 承包商准入管理访问日志ID
     */
    @ApiModelProperty(value = "承包商准入管理访问日志ID")
    @TableField("access_log_id")
    private String accessLogId;

    /**
     * 审核人姓名
     */
    @ApiModelProperty(value = "审核人姓名")
    @TableField("name")
    private String name;

    /**
     * 审核内容
     */
    @ApiModelProperty(value = "审核内容")
    @TableField("approval_content")
    private String approvalContent;

    /**
     * 审批状态(1:通过 2:进行中 3:驳回)
     */
    @ApiModelProperty(value = "审批状态(1:通过 2:进行中 3:驳回)")
    @TableField("approval_status")
    private String approvalStatus;

    /**
     * 审批时间
     */
    @ApiModelProperty(value = "审批时间")
    @TableField("approval_time")
    private String approvalTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "修改日志")
    private TContractorAccessLog tContractorAccessLog;

    /**
     * 审核人id
     */
    @ApiModelProperty(value = "审核人id")
    @TableField("name_by")
    private String nameBy;


    // 常量定义
    public static final String ID = "id";
    public static final String ACCESS_LOG_ID = "access_log_id";
    public static final String NAME = "name";
    public static final String APPROVAL_CONTENT = "approval_content";
    public static final String APPROVAL_STATUS = "approval_status";
    public static final String STATUS = "status";
    public static final String REMARKS = "remarks";
}
