package com.testor.module.hire.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 组织机构表
 * </p>
 *
 * @author caoqiang
 * @since 2024-09-11
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_sys_org")
public class TSysOrg implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 机构表主键
     */
    @TableId(value = "org_id")
    private String orgId;

    /**
     * 父级机构主键，如果是顶级节点值为0
     */
    @TableField("parent_id")
    private String parentId;

    /**
     * 所有父级机构主键以英文逗号隔开如：一级，二级等
     */
    @TableField("parent_ids")
    private String parentIds;

    /**
     * 排序号
     */
    @TableField("tree_sort")
    private BigDecimal treeSort;

    /**
     * 层次级别，1顶级依次类推
     */
    @TableField("tree_level")
    private BigDecimal treeLevel;

    /**
     * 机构名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 机构编码
     */
    @TableField("org_code")
    private String orgCode;

    /**
     * 联系地址
     */
    @TableField("address")
    private String address;

    /**
     * 邮政编码
     */
    @TableField("zip_code")
    private String zipCode;

    /**
     * 负责人
     */
    @TableField("leader")
    private String leader;

    /**
     * 电话
     */
    @TableField("phone_no")
    private String phoneNo;

    /**
     * 传真
     */
    @TableField("fax")
    private String fax;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    @TableLogic
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @TableField("create_date")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @TableField("update_date")
    private Date updateDate;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;

    /**
     * 是否部门  1部门 0 机构
     */
    @TableField("is_dept")
    private String isDept;

    /**
     * 所在省
     */
    @TableField("province")
    private String province;

    /**
     * 所在市
     */
    @TableField("city")
    private String city;

    /**
     * 所在县
     */
    @TableField("county")
    private String county;

    /**
     * 经度
     */
    @TableField("longitude")
    private String longitude;

    /**
     * 纬度
     */
    @TableField("latitude")
    private String latitude;

    /**
     * 企业性质（字典类型：NATURE）
     */
    @TableField("nature")
    private String nature;

    /**
     * 是否为租赁库 0否 1是
     */
    @TableField("is_rent")
    private String isRent;


    public static final String ORG_ID = "org_id";

    public static final String PARENT_ID = "parent_id";

    public static final String PARENT_IDS = "parent_ids";

    public static final String TREE_SORT = "tree_sort";

    public static final String TREE_LEVEL = "tree_level";

    public static final String ORG_NAME = "org_name";

    public static final String ORG_CODE = "org_code";

    public static final String ADDRESS = "address";

    public static final String ZIP_CODE = "zip_code";

    public static final String LEADER = "leader";

    public static final String PHONE_NO = "phone_no";

    public static final String FAX = "fax";

    public static final String EMAIL = "email";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

    public static final String REMARKS = "remarks";

    public static final String IS_DEPT = "is_dept";

    public static final String PROVINCE = "province";

    public static final String CITY = "city";

    public static final String COUNTY = "county";

    public static final String LONGITUDE = "longitude";

    public static final String LATITUDE = "latitude";

    public static final String NATURE = "nature";

    public static final String IS_RENT = "is_rent";

}
