package com.testor.module.mq.controller;


import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.testor.module.mq.domain.OrganizationEntity;
import com.testor.module.mq.service.WeatherService;
import com.testor.module.mq.vo.WeatherDetailInfoVO;
import com.testor.module.mq.vo.WeatherWarnInfoVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.List;

@RestController
@RequestMapping("/weather/warn")
@Api(value = "weatherDoman", tags = "首页，天气预警信息接口")
@Slf4j
public class WeatherNoticeController {
    //查询下面有没有挂在粮库，或者本身是粮库，获取粮库的市区信息，根据市查询编码

    @Autowired
    private WeatherService weatherService;

    @GetMapping("/getMessage")
    @ApiOperation(value = "获取首页自然灾害预警信息", notes = "")
    public BaseResponse<BaseResponseList<WeatherWarnInfoVO>> getWeatherList(String orgId) {
        BaseResponse<BaseResponseList<WeatherWarnInfoVO>> baseResponse = new BaseResponse<>();

        List<WeatherWarnInfoVO> resultList = weatherService.getWarnList(orgId);
        BaseResponseList<WeatherWarnInfoVO> baseResponseList = new BaseResponseList<>();
        if (CollectionUtils.isEmpty(resultList)) {
            return baseResponse;
        } else {
            baseResponseList.setData(resultList);
            baseResponseList.setTotal(resultList.size());
            baseResponse.setData(baseResponseList);
            return baseResponse;
        }

    }

    @SneakyThrows
    @GetMapping("/exportOMData")
    @ApiOperation(value = "导出运维统计", notes = "")
    public BaseResponse<String> exportOMData(HttpServletResponse response, @RequestParam(defaultValue = "0") String pages, @RequestParam(defaultValue = "10") String limits) {
        BaseResponse<String> result = new BaseResponse<>();
        List<OrganizationEntity> organizationEntities = weatherService.getOrganizationEntities(pages, limits);
        String fileName = URLEncoder.encode("运维数据" + pages, "utf-8");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        response.addHeader("Pargam", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        EasyExcel.write(response.getOutputStream(), OrganizationEntity.class).registerWriteHandler(new LongestMatchColumnWidthStyleStrategy()).sheet("节能环保月报").doWrite(organizationEntities);
        result.setMsg("导出成功");
        return result;
    }

    @GetMapping("/getMessageDetail")
    @ApiOperation(value = "获取首页自然灾害预警信息-详情", notes = "")
    public BaseResponse<WeatherDetailInfoVO> getMessageDetail(String id) {
        WeatherDetailInfoVO weatherDetail = weatherService.findWeatherDetail(id);
        BaseResponse<WeatherDetailInfoVO> result = new BaseResponse<>();
        result.setData(weatherDetail);
        return result;
    }


}
