package com.testor.module.mq.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


@Data
@ApiModel("天气预警信息实体类")
public class WeatherWarnInfoVO extends SuperModel {

    @ApiModelProperty("预警信息")
    private String warnMessage;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("预警时间")
    private Date   warnTime;

    private String code;

    private String sender;

    private String colorMsg;

	private String areaCode;

    private String id;
}
